/*
 * Decompiled with CFR 0.152.
 */
package stanford.cs106.io;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import stanford.cs106.io.LimitedPrintStream;

public class OutputCapturer {
    private static final PrintStream SYSTEM_OUT = System.out;
    private static final PrintStream SYSTEM_ERR = System.err;
    private static ByteArrayOutputStream outputStream = null;

    public static boolean isCapturing() {
        return outputStream != null;
    }

    public static synchronized void start() {
        OutputCapturer.start(true);
    }

    public static synchronized void start(boolean limit) {
        if (OutputCapturer.isCapturing()) {
            OutputCapturer.stop();
        }
        outputStream = new ByteArrayOutputStream(16384);
        PrintStream out = limit ? new LimitedPrintStream(outputStream) : new PrintStream(outputStream);
        System.setOut(out);
        System.setErr(out);
    }

    public static synchronized String stop() {
        String actualOutput = "";
        if (OutputCapturer.isCapturing()) {
            System.out.flush();
            System.err.flush();
            System.setOut(SYSTEM_OUT);
            System.setErr(SYSTEM_ERR);
            if (OutputCapturer.isCapturing()) {
                actualOutput = outputStream.toString().replace("\r", "");
            }
            outputStream = null;
        }
        return actualOutput;
    }
}

