/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import stanford.cs106.diff.DiffGui;
import stanford.cs106.gui.WindowCloseKeyListener;
import stanford.spl.SPLWindowSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutograderUnitTestGUI
extends Observable
implements ActionListener,
MouseListener {
    private static final int DIALOG_WIDTH = 500;
    private static final Color ZEBRA_STRIPE_COLOR_1 = new Color(250, 250, 250);
    private static final Color ZEBRA_STRIPE_COLOR_2 = new Color(235, 235, 235);
    private static final Color PASS_COLOR = new Color(0, 96, 0);
    private static final Color FAIL_COLOR = new Color(96, 0, 0);
    private static final Color WARN_COLOR = new Color(112, 112, 0);
    private static AutograderUnitTestGUI instance;
    private static AutograderUnitTestGUI styleCheckInstance;
    private JFrame frame = null;
    private JScrollPane scroll = null;
    private Box contentPaneBox = null;
    private Container currentCategory = null;
    private JLabel descriptionLabel = null;
    private JLabel southLabel = null;
    private Map<String, Container> allCategories = new LinkedHashMap<String, Container>();
    private Map<String, JLabel> allTestDescriptions = new LinkedHashMap<String, JLabel>();
    private Map<String, JLabel> allTestResultLabels = new LinkedHashMap<String, JLabel>();
    private Map<JLabel, String> labelToTestName = new LinkedHashMap<JLabel, String>();
    private Map<String, Map<String, String>> allTestDetails = new LinkedHashMap<String, Map<String, String>>();
    private int passCount = 0;
    private int testCount = 0;

    public static synchronized AutograderUnitTestGUI getInstance() {
        if (instance == null) {
            instance = new AutograderUnitTestGUI();
            AutograderUnitTestGUI.instance.frame.setTitle("Autograder Tests");
        }
        return instance;
    }

    public static synchronized AutograderUnitTestGUI getInstance(boolean isStyleCheck) {
        if (isStyleCheck) {
            return AutograderUnitTestGUI.getStyleCheckInstance();
        }
        return AutograderUnitTestGUI.getInstance();
    }

    public static synchronized AutograderUnitTestGUI getStyleCheckInstance() {
        if (styleCheckInstance == null) {
            styleCheckInstance = new AutograderUnitTestGUI();
            AutograderUnitTestGUI.styleCheckInstance.frame.setTitle("Style Checker");
        }
        return styleCheckInstance;
    }

    public AutograderUnitTestGUI() {
        this.frame = new JFrame();
        this.frame.setDefaultCloseOperation(1);
        this.frame.setVisible(false);
        this.descriptionLabel = new JLabel("Autograder Tests");
        this.descriptionLabel.setHorizontalAlignment(0);
        this.descriptionLabel.setAlignmentX(0.5f);
        this.shrinkFont(this.descriptionLabel);
        this.frame.add((Component)this.descriptionLabel, "North");
        this.contentPaneBox = Box.createVerticalBox();
        this.scroll = new JScrollPane(this.contentPaneBox);
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.scroll.getVerticalScrollBar().setUnitIncrement(32);
        this.frame.add((Component)this.scroll, "Center");
        this.southLabel = new JLabel(" ");
        this.southLabel.setHorizontalAlignment(0);
        this.southLabel.setAlignmentX(0.5f);
        this.frame.add((Component)this.southLabel, "South");
        this.updateSouthText();
        new WindowCloseKeyListener(this.frame);
        SPLWindowSettings.loadWindowLocation(this.frame);
        SPLWindowSettings.saveWindowLocation(this.frame);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.showTestDetails(event.getActionCommand());
    }

    public Container addCategory(String name) {
        if (!this.allCategories.containsKey(name)) {
            this.currentCategory = Box.createVerticalBox();
            this.allCategories.put(name, this.currentCategory);
            if (!name.isEmpty()) {
                TitledBorder border = BorderFactory.createTitledBorder(name);
                border.setTitleJustification(0);
                ((Box)this.currentCategory).setBorder(border);
                this.currentCategory.setBackground(ZEBRA_STRIPE_COLOR_2);
            }
            this.contentPaneBox.add(this.currentCategory);
            this.checkVisibility();
        }
        return this.allCategories.get(name);
    }

    public void addTest(String testName, String categoryName) {
        this.currentCategory = this.addCategory(categoryName);
        ++this.testCount;
        JPanel testPanel = new JPanel(new BorderLayout());
        if (this.testCount % 2 == 0) {
            testPanel.setBackground(ZEBRA_STRIPE_COLOR_1);
        } else {
            testPanel.setBackground(ZEBRA_STRIPE_COLOR_2);
        }
        JLabel testCountLabel = new JLabel(String.format("%3d. ", this.testCount));
        this.labelToTestName.put(testCountLabel, testName);
        testCountLabel.setHorizontalAlignment(4);
        testCountLabel.setAlignmentX(1.0f);
        Font oldFont = testCountLabel.getFont();
        testCountLabel.setFont(new Font("Monospaced", 1, oldFont.getSize()));
        testPanel.add((Component)testCountLabel, "West");
        String testNameShort = testName.replaceAll("Test_[0-9]{1,5}_", "");
        JLabel testNameLabel = new JLabel(testNameShort);
        this.labelToTestName.put(testNameLabel, testName);
        this.allTestDescriptions.put(testName, testNameLabel);
        testNameLabel.setToolTipText("Click to see detailed results from this test.");
        this.shrinkFont(testNameLabel);
        testNameLabel.setFont(testNameLabel.getFont().deriveFont(1));
        testPanel.add((Component)testNameLabel, "Center");
        testNameLabel.addMouseListener(this);
        JLabel resultIconLabel = new JLabel(new ImageIcon("running.gif"));
        this.shrinkFont(resultIconLabel, 2);
        resultIconLabel.setHorizontalTextPosition(2);
        resultIconLabel.setToolTipText("Click to see detailed results from this test.");
        this.labelToTestName.put(resultIconLabel, testName);
        resultIconLabel.addMouseListener(this);
        this.allTestResultLabels.put(testName, resultIconLabel);
        testPanel.add((Component)resultIconLabel, "East");
        this.currentCategory.add(testPanel);
        this.checkVisibility();
    }

    public void clearTests() {
        this.currentCategory = null;
        this.allCategories.clear();
        this.allTestDetails.clear();
        this.allTestResultLabels.clear();
        this.labelToTestName.clear();
        this.passCount = 0;
        this.testCount = 0;
        this.contentPaneBox.removeAll();
        this.contentPaneBox.validate();
        this.scroll.validate();
        this.updateSouthText();
        this.checkVisibility();
    }

    public boolean isEmpty() {
        return this.allCategories.isEmpty();
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        JLabel label = (JLabel)event.getSource();
        String testName = this.labelToTestName.get(label);
        if (testName != null) {
            this.showTestDetails(testName);
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    public void setDescription(String text) {
        text = text.replaceAll("[ \t\r\n\f]+", " ");
        text = text.replaceAll("Note:", "<b>Note:</b>");
        text = text.replaceAll("Warning:", "<b>Warning:</b>");
        text = text.replaceAll("Error:", "<b>Error:</b>");
        this.descriptionLabel.setText("<html><body style='width: 500; max-width: 500'><center>" + text + "</center></body></html>");
        this.descriptionLabel.validate();
        this.checkVisibility();
    }

    private String getTestResult(String testName) {
        JLabel testNameLabel = this.allTestDescriptions.get(testName);
        if (testNameLabel == null) {
            return "no such test";
        }
        if (testNameLabel.getForeground().equals(FAIL_COLOR)) {
            return "fail";
        }
        if (testNameLabel.getForeground().equals(WARN_COLOR)) {
            return "warn";
        }
        if (testNameLabel.getForeground().equals(PASS_COLOR)) {
            return "pass";
        }
        if (this.allTestDetails.containsKey(testName) && this.allTestDetails.get(testName).containsKey("passed")) {
            String passed = this.allTestDetails.get(testName).get("passed");
            return passed.equalsIgnoreCase("true") ? "pass" : "fail";
        }
        return "unknown";
    }

    public boolean setTestResult(String testName, String result) {
        if ((result = result.toLowerCase().intern()) == "error") {
            result = "fail";
        }
        JLabel testNameLabel = this.allTestDescriptions.get(testName);
        JLabel resultIconLabel = this.allTestResultLabels.get(testName);
        if (testNameLabel == null || resultIconLabel == null) {
            return false;
        }
        String existingResult = this.getTestResult(testName).intern();
        if ((existingResult == "fail" || existingResult == "warn") && result != "fail") {
            return true;
        }
        resultIconLabel.setIcon(new ImageIcon(String.valueOf(result) + ".gif"));
        if (result == "pass") {
            ++this.passCount;
            testNameLabel.setForeground(PASS_COLOR);
        } else if (result == "fail") {
            testNameLabel.setForeground(FAIL_COLOR);
        } else if (result == "warn") {
            testNameLabel.setForeground(WARN_COLOR);
        }
        this.updateSouthText();
        return true;
    }

    public void setTestDetails(String testName, Map<String, String> details) {
        String existingResult = this.getTestResult(testName).intern();
        if (existingResult == "fail" || existingResult == "warn") {
            return;
        }
        this.allTestDetails.put(testName, details);
    }

    public boolean setTestRuntime(String testName, int runtimeMS) {
        JLabel resultIconLabel = this.allTestResultLabels.get(testName);
        if (resultIconLabel == null) {
            return false;
        }
        String text = " (" + runtimeMS + "ms)";
        resultIconLabel.setText(text);
        return true;
    }

    private void checkVisibility() {
        this.contentPaneBox.revalidate();
        this.scroll.revalidate();
        this.frame.revalidate();
        this.frame.validate();
        this.frame.pack();
        this.frame.setSize(this.frame.getWidth() + 32, this.frame.getHeight());
        if (this.frame.isVisible() != !this.isEmpty()) {
            this.frame.setVisible(!this.isEmpty());
        }
        this.scroll.getVerticalScrollBar().setValue(this.scroll.getVerticalScrollBar().getMaximum());
    }

    private void showTestDetails(String testName) {
        String valueType;
        Map<String, String> deets = this.allTestDetails.get(testName);
        if (deets == null) {
            return;
        }
        boolean passed = deets.containsKey("passed") && deets.get("passed").equalsIgnoreCase("true");
        String type = deets.containsKey("testType") ? deets.get("testType").toUpperCase().intern() : "";
        String message = deets.get("message");
        if (type == "ASSERT_EQUALS") {
            message = String.valueOf(message) + " (must be equal)";
        } else if (type == "ASSERT_NOT_EQUALS") {
            message = String.valueOf(message) + " (must be non-equal)";
        } else if (type == "ASSERT_NEAR") {
            message = String.valueOf(message) + " (must be nearly equal)";
        } else if (type == "ASSERT_DIFF") {
            message = String.valueOf(message) + " (program output must match)";
        } else if (type == "ASSERT_TRUE") {
            message = String.valueOf(message) + " (must be true)";
        } else if (type == "ASSERT_FALSE") {
            message = String.valueOf(message) + " (must be false)";
        } else if (type == "EXCEPTION") {
            message = String.valueOf(message) + " (threw exception)";
        } else if (type == "NOT_EXCEPTION") {
            message = String.valueOf(message) + " (didn't throw expected exception)";
        } else if (type == "PASS") {
            message = String.valueOf(message) + " (passed)";
        } else if (type == "FAIL") {
            message = String.valueOf(message) + " (failed)";
        }
        String expected = deets.get("expected");
        String student = deets.get("student");
        String string = valueType = deets.containsKey("valueType") ? deets.get("valueType").toLowerCase().intern() : "";
        if (valueType == "string") {
            expected = "\"" + expected + "\"";
            student = "\"" + student + "\"";
        } else if (valueType == "char") {
            expected = "'" + expected + "'";
            student = "'" + student + "'";
        }
        boolean shouldShowJOptionPane = true;
        if (type == "ASSERT_EQUALS" || type == "ASSERT_NOT_EQUALS" || type == "ASSERT_NEAR" || type == "STYLE_CHECK") {
            String htmlMessage = "";
            htmlMessage = String.valueOf(htmlMessage) + "<html><body style='max-width: 500px;'>";
            htmlMessage = String.valueOf(htmlMessage) + "<p>" + message + "</p>";
            htmlMessage = String.valueOf(htmlMessage) + "<ul>";
            htmlMessage = String.valueOf(htmlMessage) + "<li><font style='font-family: monospaced' color='#00aa00'>expected:</font>" + expected + "</li>";
            htmlMessage = String.valueOf(htmlMessage) + "<li><font style='font-family: monospaced' color='#aa0000'>student :</font>" + student + "</li>";
            htmlMessage = String.valueOf(htmlMessage) + "</ul>";
            message = htmlMessage = String.valueOf(htmlMessage) + "</body></html>";
        } else if (type == "ASSERT_DIFF") {
            shouldShowJOptionPane = false;
            new DiffGui("expected output", expected, "student output", student).show();
        }
        if (shouldShowJOptionPane) {
            JOptionPane.showMessageDialog(this.frame, message, testName, passed ? 1 : 0);
        }
        this.setChanged();
        this.notifyObservers(testName);
    }

    private void shrinkFont(JComponent button) {
        this.shrinkFont(button, 1);
    }

    private void shrinkFont(JComponent button, int amount) {
        Font font = button.getFont();
        font = font.deriveFont((float)(font.getSize() - amount));
        button.setFont(font);
    }

    private void updateSouthText() {
        this.southLabel.setText("passed " + this.passCount + " / " + this.testCount + " tests");
    }
}

