/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import stanford.spl.Base64;
import stanford.spl.GInteractor;
import stanford.spl.SplPipeDecoder;

public class GBufferedImage
extends GInteractor {
    private static final long serialVersionUID = 1L;
    private BufferedImage bufferedImage;
    private int imageWidth;
    private int imageHeight;
    private int backgroundColor;
    private JLabel label;

    public GBufferedImage(int width, int height) {
        this(width, height, 0);
    }

    public GBufferedImage(int width, int height, int backgroundColor) {
        super(new JLabel("HOORAY"));
        this.imageWidth = width;
        this.imageHeight = height;
        this.backgroundColor = backgroundColor;
        this.bufferedImage = new BufferedImage(width, height, 1);
        this.label = (JLabel)this.getInteractor();
        if (backgroundColor != 0) {
            this.fill(backgroundColor);
        }
        this.repaintImage();
    }

    public void clear() {
        this.fill(this.backgroundColor);
    }

    public void fill(int rgb) {
        int y = 0;
        while (y < this.imageHeight) {
            int x = 0;
            while (x < this.imageWidth) {
                this.bufferedImage.setRGB(x, y, rgb);
                ++x;
            }
            ++y;
        }
        this.repaintImage();
    }

    public void fillRegion(int x, int y, int width, int height, int rgb) {
        int yy = y;
        while (yy < y + height) {
            int xx = x;
            while (xx < x + width) {
                this.bufferedImage.setRGB(xx, yy, rgb);
                ++xx;
            }
            ++yy;
        }
        this.repaintImage();
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void load(String filename) {
        try {
            this.bufferedImage = ImageIO.read(new File(filename));
            this.imageWidth = this.bufferedImage.getWidth();
            this.imageHeight = this.bufferedImage.getHeight();
            this.repaintImage();
            SplPipeDecoder.writeResult(this.toStringBase64());
        }
        catch (Exception ex) {
            SplPipeDecoder.writeResult("error:" + ex.getClass().getSimpleName() + ": " + ex.getMessage().replace('\n', ' '));
        }
    }

    public void resize(int w, int h, boolean retain) {
        BufferedImage oldImage = this.bufferedImage;
        this.bufferedImage = new BufferedImage(w, h, 1);
        this.imageWidth = w;
        this.imageHeight = h;
        this.fill(this.backgroundColor);
        if (retain) {
            Graphics g = this.bufferedImage.getGraphics();
            g.drawImage(oldImage, 0, 0, this.label);
        }
        this.repaintImage();
    }

    public void save(String filename) {
        String extension = "png";
        int dot = filename.lastIndexOf(46);
        if (dot >= 0) {
            extension = filename.substring(dot + 1).toLowerCase();
        }
        try {
            ImageIO.write((RenderedImage)this.bufferedImage, extension, new File(filename));
            SplPipeDecoder.writeResult("ok");
        }
        catch (Exception ex) {
            SplPipeDecoder.writeResult("error:" + ex.getClass().getSimpleName() + ": " + ex.getMessage().replace('\n', ' '));
        }
    }

    public void setRGB(int x, int y, int rgb) {
        this.bufferedImage.setRGB(x, y, rgb);
        this.repaintImage();
    }

    public String toStringBase64() {
        StringBuilder sb = new StringBuilder(262144);
        sb.append(this.imageWidth);
        sb.append('\n');
        sb.append(this.imageHeight);
        sb.append('\n');
        int y = 0;
        while (y < this.imageHeight) {
            int x = 0;
            while (x < this.imageWidth) {
                int px = this.bufferedImage.getRGB(x, y);
                sb.append(String.format("#%06x\n", px & 0xFFFFFF));
                ++x;
            }
            ++y;
        }
        String base64 = Base64.encodeBytes(sb.toString().getBytes());
        return base64;
    }

    private void repaintImage() {
        this.label.setIcon(new ImageIcon(this.bufferedImage));
        Dimension size = new Dimension(this.imageWidth, this.imageHeight);
        this.label.setPreferredSize(size);
        this.label.setSize(size);
    }
}

