/*
 * Decompiled with CFR 0.152.
 */
package stanford.spl;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import stanford.cs106.gui.GuiUtils;
import stanford.cs106.gui.WindowCloseKeyListener;
import stanford.cs106.util.StringUtils;
import stanford.spl.SPLWindowSettings;

public class TextFileDialog {
    public static final int DEFAULT_ROWS = 20;
    public static final int DEFAULT_COLUMNS = 80;
    public static final int MIN_ROWS = 5;
    public static final int MIN_COLUMNS = 40;
    public static final int MAX_ROWS = 50;
    public static final int MAX_COLUMNS = 100;

    private TextFileDialog() {
    }

    public static void showDialog(Window parent, String title, String text) {
        TextFileDialog.showDialog(parent, title, text, 20, 80);
    }

    public static void showDialog(Window parent, String title, String text, int rows, int cols) {
        if (rows <= 0) {
            rows = 20;
        }
        if (cols <= 0) {
            cols = 80;
        }
        int height = StringUtils.getHeight(text);
        int width = StringUtils.getWidth(text);
        height = Math.max(5, Math.min(50, height));
        width = Math.max(40, Math.min(100, width));
        final JDialog dialog = new JDialog(parent);
        dialog.setTitle(title);
        dialog.setModal(true);
        dialog.setDefaultCloseOperation(2);
        JTextArea textArea = new JTextArea(text, height, width);
        textArea.setEditable(false);
        Font oldFont = textArea.getFont();
        textArea.setFont(new Font("Monospaced", 0, oldFont.getSize()));
        JScrollPane center = new JScrollPane(textArea);
        dialog.add((Component)center, "Center");
        JPanel south = new JPanel();
        JButton ok = new JButton("OK");
        ok.setIcon(GuiUtils.extractOptionPaneIcon("OK"));
        ok.setMnemonic('O');
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        south.add(ok);
        dialog.add((Component)south, "South");
        new WindowCloseKeyListener(dialog);
        dialog.pack();
        SPLWindowSettings.loadWindowLocation(dialog);
        SPLWindowSettings.saveWindowLocation(dialog);
        ok.requestFocus();
        dialog.setVisible(true);
    }

    static void growFont(JComponent button) {
        TextFileDialog.growFont(button, 1);
    }

    static void growFont(JComponent button, int amount) {
        Font font = button.getFont();
        font = font.deriveFont((float)(font.getSize() + amount));
        button.setFont(font);
    }

    static void widen(JComponent component, int px) {
        Dimension size = component.getPreferredSize();
        size.width += px;
        component.setPreferredSize(size);
    }
}

