// Testing Big O

#include "console.h"
#include "map.h"
#include "strlib.h"
#include "testing/SimpleTest.h"
#include "timer.h"
#include "vector.h"
#include <iomanip>
#include <iostream>
#include <unistd.h>

using namespace std;

int main() {
    cout << "Note: this program can take a few minutes to run." << endl;
    runSimpleTests(ALL_TESTS);
    return 0;
}

int vectorMax(Vector<int> &v) {
    int currentMax = v[0];
    int n = v.size();
    for (int i = 1; i < n; i++) {
        if (currentMax < v[i]) {
            currentMax = v[i];
        }
    }
    return currentMax;
}

int quadraticNestedLoop(int n) {
    int result = 0;
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n; j++) {
            result++;
            usleep(100); // to magnify effect
        }
    }
    return result;
}

int cubicNestedLoop(int n) {
    int result = 0;
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n; j++) {
            for (int k = 0; k < n; k++) {
                result++;
                usleep(10); // to magnify effect
            }
        }
    }
    return result;
}

void populateVec(Vector<int> &vec, int n, bool insert = true) {
    for (int i = 0; i < n; i++) {
        if (insert) {
            vec.insert(0, i);
        } else {
            vec.add(i);
        }
    }
}

/* * * * * * Test Cases * * * * * */

PROVIDED_TEST("Vector max function, max is first") {
    // create vectors that start at 40000 elements
    // and double 10 times
    const int start = 40000;
    Vector<int> vec;
    for (int i = 0; i < 12; i++) {
        int numElements = start * (1 << i); // double each time
        for (int j = numElements / 2; j > 0; j--) {
            vec.add(j);
        }
        TIME_OPERATION(numElements, vectorMax(vec));
    }
}

PROVIDED_TEST("Vector max function, max is last") {
    // create vectors that start at 40000 elements
    // and double 10 times
    const int start = 40000;
    Vector<int> vec;
    for (int i = 0; i < 12; i++) {
        int numElements = start * (1 << i); // double each time
        for (int j = numElements / 2; j < numElements; j++) {
            vec.add(j);
        }
        TIME_OPERATION(numElements, vectorMax(vec));
    }
}

PROVIDED_TEST("Testing quadratic nested loop") {
    string operationName = "quadratic nested loop";

    // the following can be modified for different tests
    int start = 10;
    int iterations = 15;
    double multFactor = 2;

    cout << "Timing Operation: " << operationName << endl;
    for (int i = 0; i < iterations; i++) {
        int numElements = start * (1 + multFactor * i); // double each time
        TIME_OPERATION(numElements, quadraticNestedLoop(numElements));
    }
}

PROVIDED_TEST("Testing cubic nested loop") {
    // the following can be modified for different tests
    int start = 10;
    int iterations = 15;
    double multFactor = 1.3;

    for (int i = 0; i < (iterations / 2); i++) {
        int numElements = start * (1 + multFactor * i); // double each time
        TIME_OPERATION(numElements, cubicNestedLoop(numElements));
    }
}

PROVIDED_TEST("Inserting into a vector") {
    // the following can be modified for different tests
    int start = 20000;
    int iterations = 7;
    double multFactor = 2;

    Vector<int> vecToPopulate;
    for (int i = 0; i < iterations; i++) {
        int numElements = start * (i + 1) * multFactor; // double each time
        TIME_OPERATION(numElements, populateVec(vecToPopulate, numElements));
    }
}

PROVIDED_TEST("Appending to a vector") {
    // the following can be modified for different tests
    int start = 20000;
    int iterations = 7;
    double multFactor = 2;

    Vector<int> vecToPopulate;
    for (int i = 0; i < iterations; i++) {
        int numElements = start * (i + 1) * multFactor; // double each time
        TIME_OPERATION(numElements,
                       populateVec(vecToPopulate, numElements, false));
    }
}
