#!/usr/bin/env python3

import matplotlib.pyplot as plt
plt.style.use('seaborn-whitegrid')
import numpy as np

"""
data should be in the form: (ends with 2 blank lines)
label1
x0,y0
x1,y1
...
xn,yn

label2
x0,y0
x1,y1
...
xn,yn


"""
testData = """label1
1,2
2,3
4,5

label2
1,3
5,5
8,7

"""
def readData():
    data = ""
    last_line = ""
    while True:
        line = input()
        if line == "" and last_line == "":
            break
        data += line + '\n'
        last_line = line
    return data

def parseData(data):
    all_lines = data.split('\n')
    plot_lines = []
    line_index = 0

    while line_index < len(all_lines) - 1:
        plot_line = {
            'label' : all_lines[line_index],
            'x' : np.array([]),
            'y' : np.array([])
        }
        line_index += 1
        while all_lines[line_index] != "":
            x, y = all_lines[line_index].split(',')
            plot_line['x'] = np.append(plot_line['x'], float(x))
            plot_line['y'] = np.append(plot_line['y'], float(y))
            line_index += 1
        plot_lines.append(plot_line)
        line_index += 1
    return plot_lines

def main():
    colors = ['blue', 'red', 'green', 'orange', 'purple', 'magenta']
    plt.rcParams.update({'font.size': 18})

    data = readData()
    # data = testData
    print(data)
    plot_lines = parseData(data)

    for idx, plot_line in enumerate(plot_lines):
        plt.plot(plot_line['x'], plot_line['y'], '-ok', color=colors[idx % len(colors)], label=plot_line['label'], linewidth=4, markersize=10)

    plt.legend()
    plt.title('Algorithmic Growth')
    plt.ylabel('time (milliseconds)')
    plt.xlabel('problem size')
    plt.ticklabel_format(useOffset=False, style="plain")

    plt.show()

if __name__ == "__main__":
    main()

