// Tests for Vector

#include "StackInt.h"
#include "console.h"
#include <iostream>
#include "testing/SimpleTest.h"

using namespace std;

int main() {
    runSimpleTests(ALL_TESTS);
    return 0;
}

PROVIDED_TEST("Testing isEmpty") {
    StackInt stack;
    EXPECT(stack.isEmpty());
}

PROVIDED_TEST("Testing size after five pushes") {
    StackInt stack;

    for (int i = 0; i < 5; i++) {
        stack.push(i);
    }

    EXPECT_EQUAL(5, stack.size());
}

PROVIDED_TEST("Testing peek after pushing five times") {
    StackInt stack;

    for (int i = 0; i < 5; i++) {
        stack.push(i);
    }

    EXPECT_EQUAL(4, stack.peek());
}

PROVIDED_TEST("Testing cout overload") {
    StackInt stack;
    stringstream ss;

    for (int i = 0; i < 5; i++) {
        stack.push(i);
    }

    ss << stack;

    EXPECT_EQUAL("top: [4, 3, 2, 1, 0]", ss.str());
}

PROVIDED_TEST("Testing pop") {
    StackInt stack;
    stringstream ss;

    for (int i = 0; i < 5; i++) {
        stack.push(i);
    }

    stack.push(100);

    EXPECT_EQUAL(100, stack.pop());
    EXPECT_EQUAL(5, stack.size());
}

PROVIDED_TEST("Testing push of 1000 elements, popping of 500") {
    StackInt stack;
    for (int i = 0; i < 1000; i++) {
        stack.push(i);
    }

    for (int i = 0; i < 500; i++) {
        stack.pop();
    }

    EXPECT_EQUAL(499, stack.pop());
}


PROVIDED_TEST("Testing push of 10000 elements, then emptying") {
    StackInt stack;
    for (int i = 0; i < 10000; i++) {
        stack.push(i);
    }

    int last_element = 9999;
    while (!stack.isEmpty()) {
        EXPECT_EQUAL(last_element, stack.pop());
        last_element--;
    }

    EXPECT(stack.isEmpty());
}
