#include "intQueue.h"

IntQueue::IntQueue()
{
    _front = nullptr;
    _back = nullptr;
}

IntQueue::~IntQueue()
{
    while (_front != nullptr) {
        Node *temp = _front;
        _front = _front->next;
        delete temp;
    }
}

void IntQueue::enqueue(int value)
{
    Node* node = new Node;

    node->data = value;
    node->next = nullptr;

    if (_back == nullptr) { // enqueue on empty queue
        _front = node;
        _back = node;
    } else {
        _back->next = node;
        _back = node;
    }
}

int IntQueue::dequeue()
{
    if (isEmpty()) {
        throw "Error! Trying to dequeue from empty queue!";
    }

    int toReturn = _front->data;

    Node* temp = _front;
    _front = _front->next;

    if (_front == nullptr) {
        _back = nullptr; // empty queue
    }

    delete temp;
    return toReturn;
}

bool IntQueue::isEmpty()
{
    return _front == nullptr;
}

int IntQueue::front()
{
    return _front->data;
}
