#include "IntStack.h"
#include "testing/SimpleTest.h"
using namespace std;

/* Utility function: Prints the contents of a linked list, in order. */
void printList(Node* list) {
    while (list != nullptr) {
        cout << list->data << endl;
        list = list->next;
    }
}

IntStack::IntStack() {
    top = nullptr;
}

IntStack::~IntStack() {
    /* FILL ME IN */
    while (top != nullptr) {
        Node* temp = top;
        top = top->next;
        delete temp;
    }
}

void IntStack::push(int value) {
    /* FILL ME IN */
    Node* newNode = new Node;
    newNode->data = value;
    newNode->next = top;
    top = newNode;
//    printList(top);
}

int IntStack::pop() {
    /* FILL ME IN */
    if (isEmpty()) {
        error("Trying to pop from an empty stack");
    }

    int value = top->data;
    Node* temp = top;
    top = top->next;
    delete temp;

    //  Lines 41 through 43 could also have been replaced with:
    //  Node* link = top->next;
    //  delete top;
    //  top = link;

    return value;
}

bool IntStack::isEmpty(){
    return top == nullptr;
}


PROVIDED_TEST("Reverse simple set of values"){
    IntStack stack;

    for (int i = 0; i < 10; i++){
        stack.push(i);
    }

    for (int i = 9; i >= 0; i--){
        EXPECT_EQUAL(i, stack.pop());
    }
}
