/* All Examples from Introduction to C++ Lecture
 * Note: this project will compile with warnings about
 * unused variables.
 */

#include <iostream>
// slide 4
#include <string>

// slide 7
#include <cctype>
#include "console.h"

// slide 13
#include "strlib.h"

using namespace std;

void mystery(string a, string &b);

int main() {
    // slide 4
    string s = "hello"; // a c++ string

    // slide 5
    string stanfordTree = "Fear the Tree";

    char c1 = stanfordTree[3];    // 'r'
    char c2 = stanfordTree.at(2); // 'a'

    cout << c1 << endl << c2 << endl << endl;

    // two ways to loop:
    for (int i = 0; i < stanfordTree.length(); i++) {
        cout << i << " : '" << stanfordTree[i] << "'" << endl;
    }
    cout << endl;

    for (char c : stanfordTree) {
        cout << "'" << c << "'" << endl;
    }
    cout << endl;

    // slide 6
    // The Caesar Cipher
    string plainText = "ATTACK AT DAWN";
    string cipherText = "";
    int key = 5; // caesar shift by five

    // only works for uppercase!
    for (int i=0;i<(int)plainText.length();i++) {
        char plainChar = plainText[i];
        char cipherChar;
        if (plainChar >= 'A' && plainChar <= 'Z') {
            cipherChar = plainText[i] + key;
            if (cipherChar > 'Z') {
                cipherChar -= 26; // wrap back around
            }
        } else {
            cipherChar = plainChar;
        }
        cipherText += cipherChar;
    }
    cout << "Plain text:  " << plainText << endl;
    cout << "Cipher text: " << cipherText << endl;
    cout << endl;

    // slide 7
    // using the cctype library
    string mixed = "ab80c3d27";
    cout << "The digits in " << mixed << ": " << endl;
    for (int i = 0; i < mixed.length(); i++) {
      if (isdigit(mixed[i])) {
          cout << mixed[i] << endl;
      }
    }
    string mystring = "my string";
    for (int i = 0; i < mystring.length(); i++) {
      mystring[i] = toupper(mystring[i]);
    }
    cout << "Now " << mystring << " is all UPPERCASE." << endl;
    cout << endl;

    // slide 8
    // string operators
    string s1 = "Chris";
    string s2 = s1 + "Gregg"; // s2 == ChrisGregg

    string s3 = "Zebra";
    if ((s1 < s3) && (s3 != "Walrus")) {
        cout << s1 << " < " << s3 << endl;
        cout << "letters earlier in the alphabet are " << endl
             << "less than letters later in the alphabet."
             << endl;
    }

    cout << endl;

    s1[0] = tolower(s1[0]); // s1 now == "chris"
    if (s1 > s3) {
        cout << s1 << " > " << s3 << endl;
        cout << "UPPERCASE letters are less than LOWERCASE letters"
             << endl;
    }

    s3.append("Giraffe"); // s2 is now "ZebraGiraffe"
    s3.erase(4,3); // s2 is now "Zebrraffe" (which would be a very cool animal)
    s3[5] = 'i'; // s2 is now "Zebrriffe"
    // s3[9] = 'e'; // BAD!!!1! PROGRAM MAY CRASH! POSSIBLE BUFFER OVERFLOW! NO NO NO!

    cout << s3 << endl;

    // slide 10

    // string hiThere = "hi" + "there";
    // Does not compile! C strings can’t be concatenated with +

    // These three all compile and work properly.
    string hiThere = string("hi") + "there";
    string hello = "hi";
    hello += "there";

    // Bug: sets n to the memory address of the C string "42" (ack!). Qt Creator will produce a warning.
    // int n = (int) "42";

    // Works – this explictly converts "42" to a C++ string,
    // and then uses the Stanford library, stringToInteger() to convert to an int
    int n = stringToInteger("42");
    cout << n << endl;

    // slide 11
    // Both bugs. Produces garbage, not "hi?" or "hi42".
    // (memory address stuff)
    string hiQuestion = "hi" + '?'; // C-string + char
    string hi41 = "hi" + 41;  // C-string + int


    // Does work because of the empty C++ string at the beginning
    string okHighQuestion = string("") + "hi" + '?';

    // Works, because of auto-conversion.
    string howdy = "hi";
    howdy += '?'; // "hi?", char '?' is converted to string

    // Adds character with ASCII value 41, ‘)’,
    // doesn’t produce “hi?41”.
    howdy += 41; // "hi?)"

    // Works, because of conversion from int to string using a function.
    howdy += integerToString(41); // "hi?41"

    cout << howdy << endl;
    cout << endl;

    // slide 12 (Mystery)

    string a = "Stanford";
    string b = "Tree";
    mystery(a,b);
    cout << a << " " << b << endl;

    return 0;
}

void mystery(string a, string &b) {
    a.erase(0,1);
    b += a[0];
    b.insert(3, "FOO");
}

