#include "StackInt.h"
#include "error.h"

// constructor
StackInt::StackInt(){
    elements = new int[INIT_CAPACITY];
    count = 0;
    capacity = INIT_CAPACITY;
}


// destructor
StackInt::~StackInt(){
    delete [] elements;
}


void StackInt::push(int value){
    if (count == capacity) {
        expand();
    }
    elements[count] = value;
    count++;
}


int StackInt::pop(){
    if (count == 0) {
        error("Cannot pop from an empty stack!");
    }
    count--;
    return elements[count];
}


int StackInt::peek(){
    if (count == 0) {
        error("Cannot peek at an empty stack!");
    }
    return elements[count - 1];
}


bool StackInt::isEmpty(){
    return count == 0;
}


int StackInt::size(){
    return count;
}


std::ostream& operator<<(std::ostream& out, StackInt &stack){
    out << "top: [";
    for (int i = stack.count - 1; i >= 0; i--) {
        out << stack.elements[i];
        if (i > 0) {
            out << ", ";
        }
    }
    out << "]";
    return out;
}


void StackInt::expand(){
    // 1. ask for new space for a new array
    int* newElements = new int[capacity * 2];

    // 2. copy the old values to the new array
    for (int i = 0; i < capacity; i++) {
        newElements[i] = elements[i];
    }

    // 3. delete the old array (give it back to the OS!)
    delete [] elements;

    // 4. point the elements to the new array
    elements = newElements;


    // 5. Update the capacity
    capacity *= 2;
}

