#include <iostream>
#include "console.h"
#include "strlib.h"
#include "testing/SimpleTest.h"
#include "RandomBag.h"
#include "BankAccount.h"

using namespace std;

/* Prints out how many items are in the bag. Note that we have to mark the
 * RandomBag::size() member function const for this to work, since otherwise
 * C++ won't know that member function doesn't mutate the bag.
 */
void printBagSize(const RandomBag& bag) {
    cout << "The bag has " << bag.size () << " things in it." << endl;
}

void randomBagDemo() {
    /* Some sample code using the RandomBag. */
    RandomBag bag;

    for (int i = 0; i < 10; i++) {
        bag.add(i);
    }

    printBagSize(bag);

    while (!bag.isEmpty()) {
        cout << "Removing " << bag.removeRandom() << endl;
    }

    printBagSize(bag);

}

struct BankAccountStruct {
    string name;
    double amount;
};

void bankDemoStructs(){
    BankAccountStruct jenny = {"Jenny", 100};
    BankAccountStruct kylie = {"Kylie", 1000};

    /* Jenny gets a paycheck and deposits it. */
    jenny.amount += 500;

    /* Kylie buys a new dog stroller for Saki. */
    kylie.amount -= 900;

    /* Jenny wants to travel to Costa Rica to hang out with sloths */
    jenny.amount -= 2000;
    /* This is BAD! Jenny doesn't have enough money to do this. */

    /* Jenny wants to transfer some money to Kylie for lunch. */
    kylie.amount += 20;
    /* This is BAD! The money appeared out of nowhere! */

    /* Jenny tries to commit identity fraud. */
    jenny.name = "Kylie";
    /* This is BAD! We shouldn't be able to do this! */

    cout << jenny.name << " " << jenny.amount << endl;
    cout << kylie.name << " " << kylie.amount << endl;

}

void bankDemoClasses(){
    BankAccount jenny("Jenny", 100);
    BankAccount kylie("Kylie", 1000);

    /* Jenny gets his paycheck and deposits it. */
    jenny.deposit(500);

    /* Kylie buys a new dog stroller for Saki. */
    kylie.withdraw(900);

    /* Jenny wants to travel to Costa Rica to hang out with sloths. */
    // jenny.withdraw(2000); // This now throws an error!

    /* Jenny wants to transfer some money to Kylie for lunch. */
    jenny.transfer(20, kylie);

    /* Jenny tries to commit identity fraud. */
    // jenny.name = "Kylie"; // This line won't compile!

    cout << jenny.getName() << " " << jenny.getAmount() << endl;
    cout << kylie.getName() << " " << kylie.getAmount() << endl;
}

int main() {

    randomBagDemo();
//    bankDemoStructs();
//    bankDemoClasses();

    return 0;
}
