/*
 * arraystack.cpp
 *
 * This file implements the members of the ArrayStack class.
 * See ArrayStack.h for declarations and documentation.
 */

#include "arraystack.h"
#include "error.h"

ArrayStack::ArrayStack()
{
    // initialize all members including our array
    _size = 0;
    _capacity = 10;
    _elements = new int[_capacity]();
}

ArrayStack::~ArrayStack() {
    // free up the memory used by our array
    delete[] _elements;
}

void ArrayStack::push(int value)
{
    if (_size == _capacity) {
        // resize to an array twice as large
        enlargeArray();
    }

    // convention: index 0 = bottom of stack;  index (size-1) = top.
    // add to end and increase size by 1
    _elements[_size] = value;
    _size++;
}

int ArrayStack::pop()
{
    // grab last element and decrease size by 1
    int top = peek();
    _elements[_size - 1] = 0;   // do we need to do this?
    _size--;
    return top;
}

int ArrayStack::peek()
{
    if (isEmpty()) {
        error("empty stack!");
    }
    return _elements[_size - 1];
}

bool ArrayStack::isEmpty()
{
    return _size == 0;
}

void ArrayStack::enlargeArray()
{
    // copy our data into a new larger array
    int* bigger = new int[2 * _capacity]();
    for (int i = 0; i < _size; i++) {
        bigger[i] = _elements[i];
    }

    // free memory used by the old smaller array
    delete[] _elements;

    // instruct the stack to use the new larger array in the future
    _elements = bigger;
    _capacity = _capacity * 2;
}

ostream& operator <<(ostream& out, ArrayStack& stack)
{
    // << operator code is able to view the private data (size and elements)
    // because it is declared as a 'friend' of the class
    out << "{";
    for (int i = 0; i < stack._size; i++) {
        out << stack._elements[i] << " ";
    }
    out << "}";
    return out;
}
