#include "console.h"
#include "testing/SimpleTest.h"
#include <iostream>
#include <string>

using namespace std;
void mystery1(int &a, int &b);
void mystery2(int &b, int c, int &a);
void mystery3(string &s);
void mystery4(string &s, int dup);

int main() {
    if (runSimpleTests(ALL_TESTS)) {
        return 0;
    }
    return 0;
}

void mystery1(int &a, int &b) {
    int temp = a;
    a = b;
    b = temp;
}

void mystery2(int &b, int c, int &a) {
    a++;
    b--;
    c += a;
}

void mystery3(string &s) {
    string newString = "this is the second string";
    s = newString;
}

void mystery4(string &s, int dup) {
    size_t initialLength = s.length();
    for (size_t i = 0; i < initialLength; i++) {
        s.insert(i * dup, dup - 1, s[i * dup]);
    }
}

// STUDENT TESTS

STUDENT_TEST("mystery test 1") {
    int a = 2;
    int b = 3;
    mystery1(a, b);
    EXPECT_EQUAL(a, 3);
    EXPECT_EQUAL(b, 2);

    const int MAX = 10;
    for (int i = 0; i < MAX; i++) {
        int c = i;
        int d = MAX - i;
        mystery1(c, d);
        EXPECT_EQUAL(c, MAX - i);
        EXPECT_EQUAL(d, i);
    }
}

STUDENT_TEST("mystery test 2") {
    int a = 5;
    int b = 2;
    int c = 8;
    mystery2(c, a, b);
    EXPECT_EQUAL(a, 5);
    EXPECT_EQUAL(b, 3);
    EXPECT_EQUAL(c, 7);
}

STUDENT_TEST("mystery test 3") {
    string firstString = "this is the first string";
    mystery3(firstString);
    EXPECT_EQUAL(firstString, "this is the second string");
}

STUDENT_TEST("mystery test 4") {
    string original = "2abcde1";
    mystery4(original, 4);
    EXPECT_EQUAL(original, "2222aaaabbbbccccddddeeee1111");
}
