/*
 * coinflips.cpp
 *
 * @author Cynthia Lee
 * @version 2024-Aut
 *
 * Demonstrates combining loops with recursion to generate all possible
 * sequences. The program generates all possible coin flip sequences,
 * i.e., sequences of H(eads) and T(ails).
 */

#include <iostream>
#include "console.h"
#include "vector.h"
#include "simpio.h"
using namespace std;


/* Function Prototypes */
void generateAllSequences(int length);
void generateAllSequences(int length, string sequence);


int main()
{
    while (true) {
        int length = getInteger("How many coin flips should we do? ");
        if (length < 0) {
            break;
        }
        generateAllSequences(length);
    }
    cout << "All done, exiting" << endl;
    return 0;
}


/*
 * Prints all sequences of H/T, and stores them in the provided vector.
 * @param length is a non-negative number of coin flips to perform
 */
void generateAllSequences(int length)
{
    string sequence = "";
    generateAllSequences(length, sequence);
}

/*
 * Recursive implementation (private)
 * Prints all sequences of H/T.
 * @param length is the number of coin flips remaining to perform
 * @pre the parameter sequence should be empty string in the originating call
 *     to this function, and will fill as the recursion unfolds
 */
void generateAllSequences(int length, string sequence)
{
    //Base case:
    // This problem is so tiny, it’s hardly a problem anymore! Just give answer.
    // this sequence doesn't need any more flips, so print it
    if (length <= 0) {
        cout << sequence << endl;
        return;
    }

    //Recursive case:
    // This problem is still a bit large, let’s
    // (1) bite off just one piece,
    // add a single H or T coin flip to the sequence,
    // and (2) delegate the remaining work to recursion.
    // recursively generate more flips
    generateAllSequences(length - 1, sequence + "H");
    generateAllSequences(length - 1, sequence + "T");
}

