/*
 * File: main.cpp
 * --------------
 * Blank C++ project configured to use Stanford cslib and Qt
 */

#include "console.h"
#include "simpio.h"
#include "map.h"
using namespace std;

int fasterFibonacci(int n, Map<int, int>& memos);

// this is the primary function
int fasterFibonacci(int n)
{
    // this will hold our results as {n, Fib(n)}, starting with our base cases
    Map<int, int> memos = { {0, 0}, {1, 1} };
    return fasterFibonacci(n, memos);
}

// this is a recursive helper function
int fasterFibonacci(int n, Map<int, int>& memos)
{
    // if we already know the answer, just return it
    if (memos.containsKey(n)) {
        return memos[n];
    } else {
        int result1;
        if (memos.containsKey(n - 1)) { // arms length recursion! No!
            result1 = memos[n - 1];
        } else {
            result1 = fasterFibonacci(n - 1, memos);
        }
        int result2;
        if (memos.containsKey(n - 2)) { // arms length recursion! No!
            result2 = memos[n - 2];
        } else {
            result2 = fasterFibonacci(n - 2, memos);
        }

        memos[n] = result1 + result2;
        return result1 + result2;
    }
}

int main()
{
    cout << fasterFibonacci(40) << endl;
    return 0;
}
