/*
 * FILE: CIRCLE LINE FRACTALS
 * --------------------------
 * This program draws a Circle line of a constant depth on the screen.
 * A Circle line of depth N is 2 circle lines of depth N-1: one on
 * each side of the main circle
 */

#include "gwindow.h"
#include <math.h>
#include "console.h"
#include "simpio.h"

using namespace std;

// display constants
static const int FRACTAL_DEPTH = 6;
static const int SCREEN_WIDTH = 1000;
static const int SCREEN_HEIGHT = SCREEN_WIDTH;
static const int BASE_Y = SCREEN_HEIGHT / 4;
static const int BASE_X = SCREEN_WIDTH / 4;

/* Function: Draw Circle Line
 * ---------------------
 * A recursive function that draws a Circle line with the top
 * left at topLeft and the radius of circle of radius
 * The fractal will have "level" numbers of levels.
 */
void drawCircleLine(GWindow &window, int level, GPoint topLeft, double radius) {
    if (level == 0) {
        return;
    } else {
        window.drawOval(topLeft.x, topLeft.y, radius, radius);
        GPoint left(topLeft.x - radius / 4, topLeft.y + radius / 4);
        GPoint right(topLeft.x + radius - radius / 4, topLeft.y + radius / 4);
        drawCircleLine(window, level - 1, left, radius / 2);
        drawCircleLine(window, level - 1, right, radius / 2);

        // Up and Down makes for another interesting fractal!

        // GPoint up(topLeft.x + radius / 4, topLeft.y - radius / 4);
        // GPoint down(topLeft.x + radius / 4, topLeft.y + radius - radius / 4);
        // drawCircleLine(window, level - 1, up, radius / 2);
        // drawCircleLine(window, level - 1, down, radius / 2);
    }
}

int main() {
    GWindow w(SCREEN_WIDTH, SCREEN_HEIGHT);
    GPoint topCorner(BASE_X, BASE_Y);
    getLine("Press <return> to draw a circle line");
    w.setColor("black");
    w.setFillColor("black");
    drawCircleLine(w, FRACTAL_DEPTH, topCorner, SCREEN_WIDTH / 2.0);

    return 0;
}
