/*
 * CS 106B, Cynthia Bailey, based on code by Julie Zelenski
 *
 * @version AUT 2024
 *
 * This file provides the implementation for the Ball class
 * constructor and member functions declared in ball.h.
 */
#include "ball.h"
#include "random.h"
#include "SimpleTest.h"
using namespace std;

// program constants used by the Ball class
static const int SIZE = 50;
static const int MIN_VELOCITY = -5;
static const int MAX_VELOCITY = 5;


Ball::Ball(int id, GWindow* window)
{
    _window = window;
    _id = id;
    _x = randomInteger(0, _window->getWidth() - SIZE);
    _y = randomInteger(0, _window->getHeight() - SIZE);
    _vx = randomInteger(MIN_VELOCITY, MAX_VELOCITY);
    _vy = randomInteger(MIN_VELOCITY, MAX_VELOCITY);
}

// Draw this ball as a colored circle at its current location
// Label the ball with its id number
void Ball::draw()
{
    _window->setColor("Blue");
    _window->fillOval(_x, _y, SIZE, SIZE);
    _window->setColor("White");
    drawCenteredText(_window, _x, _y, SIZE, SIZE, integerToString(_id));
}

// Change ball's location by one velocity increment in x and y directions
// If ball crosses edge of window, "bounce" by reflecting the velocity
// in x or y direction
void Ball::move()
{
    _x += _vx;
    _y += _vy;
    // if outside left or right edge, bounce horizontally
    if (_x < 0 || _x + SIZE >= _window->getWidth()) {
        _vx = -_vx;
    }
    // if outside top or bottom edge, bounce vertically
    if (_y < 0 || _y + SIZE >= _window->getHeight()) {
        _vy = -_vy;
    }
}


