/*
 * CS 106B, Cynthia Bailey, based on code by Julie Zelenski
 *
 * @version AUT 2024
 *
 * This file declares a class named Ball.
 * A class is a template or blueprint for a new type of object.
 *
 * Each Ball object represents information about a ball.
 * A ball has a location (x,y), velocity (vx, vy) and id number.
 */
#pragma once
#include "gwindow.h"
#include "gfont.h"
#include <string>

class Ball {

  public:

    /* Constructs a ball in the provided world.
     * - id: to be used as a visual label on the ball
     * - w:  the virtual world (graphics window) in which to draw the
     *       ball. Must be already appropriately initialized.
     * The ball will be assigned a random location and velocity.
     */
    Ball(int id, GWindow* window);

    /*
     * Draws (or re-draws) this ball as a solid color circle at its
     * current location. The circle will include the id number as a
     * text label.
     */
    void draw();

    /*
     * Move this ball by one velocity increment. (Updates internal
     * state but does not (re-)draw.)
     */
    void move();

  private:
    // a 2-D virtual world where (0,0) is upper-left corner
    GWindow* _window;

    // current ball location is (_x, _y)
    int _x;
    int _y;

    // current ball velocity is [_vx, _vy]
    int _vx;
    int _vy;

    // identifier that appears as a text label on the ball
    int _id;
};













// This is a goopy piece of code needed to account for platform differences in
// how fonts are sized. Pay no attention.
static void drawCenteredText(GWindow *win, double x, double y, double width, double height, std::string text)
{
    struct { int width, height; } bounds;
    int font_size = 1;
    do {
        std::string font_desc = "Helvetica-" + integerToString(++font_size);
        win->setFont(font_desc);
        QFontMetrics metrics(GFont::toQFont(font_desc));
        bounds = { metrics.horizontalAdvance(QString::fromStdString(text)), metrics.ascent() };
    } while (bounds.height < height/2 && bounds.width < width/2);
    win->drawString(text, x + (width-bounds.width)/2, y + height - (height-bounds.height)/2);
}
