/*
 * CS 106B, Cynthia Bailey, based on code by Julie Zelenski
 *
 * @version AUT 2024
 *
 * This program is an example "client" that uses our Ball class.
 * The main purpose of writing new classes is so that various
 * client programs can use your new objects.
 */

#include <iostream>
#include <iomanip>
#include "gwindow.h"
#include "ball.h"
#include "random.h"
#include "vector.h"
#include "SimpleTest.h"
using namespace std;


int main()
{
    if (runSimpleTests(SELECTED_TESTS)) {
        return 0;
    }
    cout << "All done, exiting" << endl;
    return 0;
}


PROVIDED_TEST("Animate one bouncing ball")
{
    GWindow window;
    window.setTitle("Bouncing Balls");
    window.setLocation(0, 0);
    window.setCanvasSize(600, 400);
    window.setResizable(false);
    window.setAutoRepaint(false);
    window.setColor("Blue");

    int x    = 20;
    int y    = 20;
    int vx   = 5;
    int vy   = 5;
    int size = 50;

    for (int i = 0; i < 300; i++) {
        x += vx;
        y += vy;
        // if outside left or right edge, bounce horizontally
        if (x < 0 || x + 50 > window.getWidth()) {
            vx = -vx;
        }
        // if outside top or bottom edge, bounce vertically
        if (y < 0 || y + 50 > window.getHeight()) {
            vy = -vy;
        }

        window.clearCanvas();
        window.fillOval(x, y, size, size);
        window.repaint();
    }
    window.close();
}




STUDENT_TEST("Animate many bouncing balls")
{
    GWindow window;
    window.setTitle("Bouncing Balls");
    window.setLocation(0, 0);
    window.setCanvasSize(600, 400);
    window.setResizable(false);
    window.setAutoRepaint(false);

    // Construct many random ball objects, store all balls in a vector
    Vector<Ball> allBalls;
    for (int i = 0; i < 15; i++) {
         Ball ball(i, &window);
         allBalls.add(ball);
    }

    // animation loop: move/draw all balls in each time step
    for (int i = 0; i < 300; i++) {
        window.clearCanvas();
        for (int i = 0; i < allBalls.size(); i++) {
            allBalls[i].move();
            allBalls[i].draw();
        }
        window.repaint();
        //window.pause(10); // un-comment this if you need to slow down animation
    }
    window.close();
}
