/*
 * This file provides the implementation of the bodies of the member functions
 * and constructor for the BankAccount class declared in bankaccount.h.
 */

#include "bankaccount.h"

BankAccount::BankAccount(string name)
{
    _name = name;
    _balance = 0.00;
}

BankAccount::BankAccount(string name, double initialBalance)
{
    _name = name;
    if (initialBalance < 0.0) {
        error("Initial balance must be nonnegative.");
    }
    _balance = initialBalance;
}


void BankAccount::deposit(double money)
{
    if (money <= 0.0) {
        error("Deposit amount must be positive.");
    }
    _balance += money;
}

double BankAccount::getBalance()
{
    return _balance;
}

string BankAccount::getName()
{
    return _name;
}

void BankAccount::withdraw(double money)
{
    if (money >= 0.0) {
        _balance -= money;
    } else {
        error("Withdraw amount must be positive.");
    }
}
