/*
 * Cynthia Bailey
 * version AUT24
 *
 * This "my first C++ class" example is a class named BankAccount.
 *
 * Each BankAccount object represents information about a single
 * person's bank account, such as their name and balance.
 *
 * --> A class is a template or blueprint for a new type of objects.
 *
 * --> This .h file declares the class as a new type, including
 *     function prototypes for all the member functions and a list
 *     of all the member variables that comprise the data for each
 *     instance of the class.
 *
 * --> Implementation of each class member function is found in
 *     the accompanying bankaccount.cpp file.
 */

#ifndef _bankaccount_h
#define _bankaccount_h

#include <string>
#include "error.h"
using namespace std;

class BankAccount {
public:    
    /*
     * Opens a new bank account, owned by the person named.
     * - name: the bank account owner
     */
    BankAccount(string name);

    /*
     * Opens a new bank account, owned by the person named and including the
     * provided starting balance.
     * - name: the bank account owner
     * - initialBalance
     */
    BankAccount(string name, double initialBalance);

    /*
     * Adds money to the account.
     * - money: the amount to deposit. An error is given if it is not a positive
     *          (non-zero) number.
     */
    void deposit(double money);

    /* Returns the current account balance.
     */
    double getBalance();

    /* Returns the name of the account owner.
     */
    string getName();
    void withdraw(double money);


private:
    // --> this is where we put the Member Variables (instance variables / fields)
    string _name;
    double _balance;
};

#endif
