/*
 * Cynthia Bailey, based on previous CS106B code
 *
 * @version AUT 2024
 *
 * arraystack.cpp
 *
 * This file implements the members of the ArrayStack class.
 * See ArrayStack.h for declarations and documentation.
 */

#include "arraystack.h"
#include "error.h"

static const int INITIAL_CAPACITY = 10;

ArrayStack::ArrayStack()
{
    _size = 0;
    _capacity = INITIAL_CAPACITY;
    _elements = new int[_capacity];
}

bool ArrayStack::isEmpty()
{

    return _size == 0;
}

int ArrayStack::peek()
{
    if (isEmpty()) {
        error("Cannot access empty stack!");
    }
    return _elements[_size - 1];
}

int ArrayStack::pop()
{
    int value = peek();
    _size--;
    return value;
}

void ArrayStack::push(int value)
{
    if (_size == _capacity) {
        // resize to an array twice as large
        enlargeArray();
    }
    _elements[_size] = value;
    _size++;
}

ArrayStack::~ArrayStack() {
    // free up the memory used by our array
    delete [] _elements;
}

void ArrayStack::enlargeArray()
{
    // copy our data into a new larger array
    int* bigger = new int[2 * _capacity]();
    for (int i = 0; i < _size; i++) {
        bigger[i] = _elements[i];
    }

    // free memory used by the old smaller array
    delete [] _elements;

    // instruct the stack to use the new larger array in the future
    _elements = bigger;
    _capacity = _capacity * 2;
}

ostream& operator <<(ostream& out, ArrayStack& stack)
{
    // << operator code is able to view the private data (size and elements)
    // because it is declared as a 'friend' of the class
    out << "{";
    for (int i = 0; i < stack._size; i++) {
        out << stack._elements[i] << " ";
    }
    out << "}";
    return out;
}


