/*
 * Cynthia Bailey, based on previous CS106B code
 *
 * @version AUT 2024
 *
 * stack-client.cpp
 *
 * This program is a client that tests the ArrayStack class.
 */

#include <iostream>
#include "console.h"
#include "arraystack.h"
#include "SimpleTest.h"
using namespace std;



int main()
{
    if (runSimpleTests(SELECTED_TESTS)) {
        return 0;
    }
    cout << "All done, exiting" << endl;
    return 0;
}



/* * * * * * Test Cases * * * * * */

PROVIDED_TEST("Basic small cases for: isEmpty, push, peek, pop") {
    ArrayStack s;
    EXPECT(s.isEmpty());
    s.push(7);
    s.push(10);
    EXPECT_EQUAL(s.peek(), 10);
    EXPECT_EQUAL(s.pop(), 10);
    s.push(3);
    s.push(5);
    EXPECT_EQUAL(s.pop(), 5);
    EXPECT(!s.isEmpty());
    EXPECT_EQUAL(s.peek(), 3);
    EXPECT_EQUAL(s.pop(), 3);
    EXPECT_EQUAL(s.pop(), 7);
    EXPECT(s.isEmpty());
}

PROVIDED_TEST("Error for pop of empty stack") {
    ArrayStack s;
    EXPECT_ERROR(s.pop());
}

STUDENT_TEST("TODO: larger size that forces re-size of array structure") {
}
