/*
 * Cynthia Bailey, based on previous CS106B code
 *
 * @version AUT 2024
 *
 * arraystack.cpp
 *
 * This file implements the members of the ArrayStack class.
 * See ArrayStack.h for declarations and documentation.
 */

#include "arraystack.h"
#include "error.h"

static const int INITIAL_CAPACITY = 10;

/* Constructs a new empty stack. */
ArrayStack::ArrayStack()
{
    _size = 0;
    _capacity = INITIAL_CAPACITY;
    _elements = new int[_capacity];
}

/* Destructor; called when stack is thrown out. */
ArrayStack::~ArrayStack()
{
    delete [] _elements;
}

/* Adds the given value to the top of the stack. */
void ArrayStack::push(int value)
{
    // check that there is room for a new value
    if (_size == _capacity) {
        // if not, make room
        enlargeArray();
    }

    // add new value
    _elements[_size] = value;

    // increase size to reflect new value
    _size++;
}

/* Removes and returns the element on top of the stack.
     * Throws a string exception if stack is empty.
     */
int ArrayStack::pop()
{
    if (_size == 0) {
        error("Cannot pop from empty stack!");
    }
    _size--;
    return _elements[_size];
}

/* Returns the element on top of the stack without removing it.
     * Throws a string exception if stack is empty.
     */
int ArrayStack::peek()
{
    if (_size == 0) {
        error("Cannot peek from empty stack!");
    }
    return _elements[_size - 1];
}

/* Returns true if the stack does not contain any elements. */
bool ArrayStack::isEmpty()
{
    return _size == 0;
}

/* Makes the stack's internal array twice as large. */
void ArrayStack::enlargeArray()
{
    // allocate a new array that is 2x previous capacity
    int* newElems = new int[_capacity * 2];

    // copy over all the values
    for (int i = 0; i < _capacity; i++){
        newElems[i] = _elements[i];
    }

    // free up old array
    delete [] _elements;

    // reassign elements to new array
    _elements = newElems;

    // increase capacity var to reflect change
    _capacity *= 2;
}

















ostream& operator <<(ostream& out, ArrayStack& stack)
{
    // << operator code is able to view the private data (size and elements)
    // because it is declared as a 'friend' of the class
    out << "{";
    for (int i = 0; i < stack._size; i++) {
        out << stack._elements[i] << " ";
    }
    out << "}";
    return out;
}


