/*
 * Cynthia Bailey, based on previous CS106B code
 *
 * @version AUT 2024
 *
 * arraystack.h
 *
 * This header declares the ArrayStack class and its members.
 * An ArrayStack encapsulates the list methods from previous lectures
 * into an object that keeps track of the front of the list.
 * See ArrayStack.cpp for the implementation of the methods.
 */

#ifndef _arraystack_h
#define _arraystack_h

#include <iostream>
using namespace std;

class ArrayStack {
public:
    /* Constructs a new empty stack. */
    ArrayStack();

    /* Destructor; called when stack is thrown out. */
    ~ArrayStack();

    /* Adds the given value to the top of the stack. */
    void push(int value);

    /* Removes and returns the element on top of the stack.
     * Throws a string exception if stack is empty.
     */
    int pop();

    /* Returns the element on top of the stack without removing it.
     * Throws a string exception if stack is empty.
     */
    int peek();

    /* Returns true if the stack does not contain any elements. */
    bool isEmpty();

    /* Prints the contents of a stack to an output stream such as cout. */
    friend ostream& operator <<(ostream& out, ArrayStack& stack);

private:
    int* _elements;   // array of elements
    int _size;        // number of elements on stack
    int _capacity;    // array length

    /* Makes the stack's internal array twice as large. */
    void enlargeArray();
};

#endif
