/*
 * Cynthia Bailey
 *
 * @version AUT 2024
 *
 * Sandbox to demonstrate what happens with uninitialized memory in C/C++.
 */

#include <iostream>
#include "console.h"
#include "simpio.h"
using namespace std;

void runBank(string name);
static const int SSN_LOC = 0;
static const int CC_LOC  = 1;

int main()
{
    string cyn = "Cynthia";
    string jon = "Jonathan";
    runBank(cyn);
    runBank(jon);
    return 0;
}

void runBank(string name)
{
    int dataArr[2];  // We will store SSN in [0] and CC in [1]
    int choice = -1;

    cout << "Welcome, " << name << "!" << endl;
    cout << "Menu:" << endl;
    cout << "Enter 0 to quit." << endl;
    cout << "Enter 1 to enter SSN." << endl;
    cout << "Enter 2 to enter credit card." << endl;
    cout << "Enter 3 to print SSN." << endl;
    cout << "Enter 4 to print credit card." << endl;

    while(choice != 0) {
        choice = getInteger("Your choice: ");

        switch (choice) {
        case 1:
            dataArr[SSN_LOC] = getInteger(name + ", what is your SSN? ");
            break;
        case 2:
            dataArr[CC_LOC] = getInteger(name + ", what is your credit card no.? ");
            break;
        case 3:
            cout << name << ", your SSN is: " << dataArr[SSN_LOC] << endl;
            break;
        case 4:
            cout << name << ", your credit card is: " << dataArr[CC_LOC] << endl;
            break;
        }
    }
    cout << endl << endl;
}


