/*
 * Cynthia Bailey
 * CS106B - AUT 2024 version
 *
 * hospitalq.cpp
 *
 * This file implements the members of the HospitalQueue class.
 * See hospitalq.h for declarations and documentation.
 */

#include "hospitalq.h"
#include "error.h"
#include "strlib.h"

static const int INITIAL_CAPACITY = 10;

HospitalQueue::HospitalQueue()
{
    _size = 0;
    _capacity = INITIAL_CAPACITY;
    _elements = new Patient[_capacity];
}

HospitalQueue::~HospitalQueue() {
    // free up the memory used by our array
    delete [] _elements;
}

bool HospitalQueue::isEmpty()
{
    return _size == 0;
}

Patient HospitalQueue::front()
{
    if (isEmpty()) {
        error("Cannot access when empty!");
    }
    return _elements[0];
}

void HospitalQueue::enqueue(Patient newPatient)
{
    // resize if needed before proceeding
    if (_size == _capacity) {
        enlargeArray();
    }

    // append new patient to the end
    _elements[_size] = newPatient;

    // "bubble up" new patient to repair heap order property
    int curIndex = _size;
    // while not at room AND child priority < parents
    while (curIndex > 0 && newPatient.priority < parentPriority(curIndex)) {
        // swap parent and child
        swap(curIndex, parentIndex(curIndex));
        // update index of new node
        curIndex = parentIndex(curIndex);
    }
    _size++;
}

Patient HospitalQueue::dequeue()
{
    error("TODO: this is left as a homework exercise in some quarters so we won't do it here.");
}

void HospitalQueue::enlargeArray()
{
    // copy our data into a new larger array
    Patient* bigger = new Patient[2 * _capacity]();
    for (int i = 0; i < _size; i++) {
        bigger[i] = _elements[i];
    }

    // free memory used by the old smaller array
    delete [] _elements;

    // use the new larger array in the future
    _elements = bigger;
    _capacity = _capacity * 2;
}

int HospitalQueue::parentIndex(int child) {
    return (child - 1) / 2;
}

int HospitalQueue::leftChildIndex(int parent) {
    return 2 * parent + 1;
}

int HospitalQueue::rightChildIndex(int parent) {
    return 2 * parent + 2;
}

int HospitalQueue::parentPriority(int child) {
    return _elements[parentIndex(child)].priority;
}

void HospitalQueue::swap(int index1, int index2) {
    Patient tmp = _elements[index2];
    _elements[index2] = _elements[index1];
    _elements[index1] = tmp;
}











string HospitalQueue::asString() {
    string out = "{ ";
    for (int i = 0; i < _size; i++) {
        out += integerToString(_elements[i].priority) + " ";
    }
    out += "}";
    return out;
}



