#include "intStack.h"

IntStack::IntStack()
{
    _head = nullptr;
}

IntStack::~IntStack()
{
    while (_head != nullptr) {
        Node *temp = _head;
        _head = _head->next;
        delete temp;
    }
}

void IntStack::push(int value)
{
    Node* node = new Node;

    node->data = value;
    node->next = _head;

    _head = node;
}

int IntStack::pop()
{
    if (isEmpty()) {
        throw "Error! Trying to pop from empty stack!";
    }
   
    int toReturn = _head->data;
 
    Node* temp = _head;
    _head = _head->next;

    delete temp;
    return toReturn;
}

bool IntStack::isEmpty()
{
    return _head == nullptr;
}

int IntStack::top()
{
    return _head->data;
}
