#include "Trie.h"
#include <string>

using namespace std;

Trie::Trie() {
    _root = new TrieNode();
}

Trie::~Trie() {
    deleteTrie(_root);
}

void Trie::deleteTrie(TrieNode* node) {
    if (node == nullptr) return;

    for (char key : node->children) {
        deleteTrie(node->children[key]);
    }
    delete node;
}

void Trie::insert(const string &word) {
    TrieNode* node = _root;
    for (char c : word) {
        if (!node->children.containsKey(c)) {
            node->children[c] = new TrieNode();
        }
        node = node->children[c];
    }
    node->isEndOfWord = true;
}

bool Trie::search(const string &word) const {
    TrieNode* node = _root;
    for (char c : word) {
        if (!node->children.containsKey(c)) {
            return false;
        }
        node = node->children[c];
    }
    return node->isEndOfWord;
}

bool Trie::startsWith(const string &prefix) const {
    TrieNode* node = _root;
    for (char c : prefix) {
        if (!node->children.containsKey(c)) {
            return false;
        }
        node = node->children[c];
    }
    return true;
}
