#pragma once
#include <string>
#include "map.h"

class TrieNode {
public:
    Map<char, TrieNode*> children;
    bool isEndOfWord;

    TrieNode() : isEndOfWord(false) {}
};

class Trie {
public:
    Trie();
    ~Trie();
    void deleteTrie(TrieNode* node);
    void insert(const std::string &word);
    bool search(const std::string &word) const;
    bool startsWith(const std::string &prefix) const;

private:
    TrieNode* _root;
};
