#include "Trie.h"
#include "console.h"
#include "simpio.h"
using namespace std;

int main() {
    Trie trie;

    // Insert words into the trie
    trie.insert("apple");
    trie.insert("app");
    trie.insert("bat");
    trie.insert("ball");

    // Search for complete words
    cout << "Searching for 'apple': " << (trie.search("apple") ? "Found" : "Not found") << endl;
    cout << "Searching for 'app': " << (trie.search("app") ? "Found" : "Not found") << endl;
    cout << "Searching for 'bat': " << (trie.search("bat") ? "Found" : "Not found") << endl;
    cout << "Searching for 'ball': " << (trie.search("ball") ? "Found" : "Not found") << endl;
    cout << "Searching for 'batman': " << (trie.search("batman") ? "Found" : "Not found") << endl;

    // Check for prefixes
    cout << "Checking prefix 'app': " << (trie.startsWith("app") ? "Exists" : "Does not exist") << endl;
    cout << "Checking prefix 'bat': " << (trie.startsWith("bat") ? "Exists" : "Does not exist") << endl;
    cout << "Checking prefix 'bal': " << (trie.startsWith("bal") ? "Exists" : "Does not exist") << endl;
    cout << "Checking prefix 'cat': " << (trie.startsWith("cat") ? "Exists" : "Does not exist") << endl;

    return 0;
}
