#include "GreatTreeListRecursion.h"
using namespace std;

Node* toList(Node* root) {
    (void) root;
    return nullptr;
}

/* * * * * Test Cases Below This Point * * * * */
#include "GUI/SimpleTest.h"
#include "set.h"
#include "vector.h"

namespace {
    /* Checks if a linked structure is indeed doubly-linked. */
    bool isCorrect(Node* head, const Vector<int>& values, const Set<Node*> originals) {
        Set<Node*> seen;

        /* Shouldn't be anything before us. */
        if (head && head->left) {
            return false;
        }

        /* Walk the list confirming that the links and values are right. */
        for (int value: values) {
            /* Oops, out of values. */
            if (head == nullptr) {
                return false;
            }

            /* Make sure we're linked backwards correctly. */
            if (head->left && head->left->right != head) {
                return false;
            }

            /* Make sure we have the right value. */
            if (head->value != value) {
                return false;
            }

            /* Mark the node as seen. */
            seen += head;

            /* Make sure we're one of the originals. */
            if (!originals.contains(head)) {
                return false;
            }

            /* Make sure the next node isn't already seen. */
            if (seen.contains(head->right)) {
                return false;
            }

            /* Advance forward. */
            head = head->right;
        }

        /* We should be at a null pointer. */
        return head == nullptr;
    }

    /* All nodes in the tree. */
    Set<Node*> allNodesIn(Node* root) {
        if (root == nullptr) return {};
        return allNodesIn(root->left) + root + allNodesIn(root->right);
    }

    /* Inorder traversal. */
    Vector<int> valuesIn(Node* root) {
        if (root == nullptr) return {};
        return valuesIn(root->left) + root->value + valuesIn(root->right);
    }

    /* Linked list freeing. */
    void freeList(Node* root) {
        while (root != nullptr) {
            Node* next = root->right;
            delete root;
            root = next;
        }
    }

    /* Checks correctness on the given tree. */
    template <typename... Args> void checkCorrectness(Args... args) {
        Node* tree  = toTree(args...);
        auto nodes  = allNodesIn(tree);
        auto values = valuesIn(tree);

        Node* head = toList(tree);
        EXPECT(isCorrect(head, values, nodes));
        freeList(head);
    }
}

PROVIDED_TEST("Works for simple cases.") {
    EXPECT_EQUAL(toList(nullptr), nullptr);

    checkCorrectness("137");
    checkCorrectness(R"(   137   )",
                     R"(  /      )",
                     R"( 42      )");
    checkCorrectness(R"(   137   )",
                     R"(      \  )",
                     R"(       42)");
    checkCorrectness(R"(   137   )",
                     R"(  /   \  )",
                     R"( 19    42)");
}

PROVIDED_TEST("Works for a more elaborate tree.") {
    checkCorrectness(R"(      1       )",
                     R"(     / \      )",
                     R"(    /   2     )",
                     R"(   /   / \    )",
                     R"(  3   4   5   )",
                     R"( / \   \   \  )",
                     R"(6   7   8   9 )");
}
