#include "console.h"
#include "vector.h"
#include <iostream>
using namespace std;

struct objectT {
    int weight; // You may assume this is greater than or equal to 0
    int value;  // You may assume this is greater than or equal to 0
};

ostream &operator<<(ostream &out, objectT obj) {
    out << "{ weight: " << obj.weight << ", value: " << obj.value << "}";
    return out;
}

int fillKnapsack(Vector<objectT> &objects, int weight, int currentScore);

int fillKnapsack(Vector<objectT> &objects, int targetWeight) {
    return fillKnapsack(objects, targetWeight, 0);
}

// find the best score (not individual objects)
int fillKnapsack(Vector<objectT> &objects, int weight, int currentScore) {
    // base case #1: too much weight!
    if (weight < 0) {
        return 0;
    }

    if (objects.isEmpty()) {
        return currentScore;
    }

    // remove an object for recursion, and save
    objectT originalObject = objects.remove(objects.size() - 1);

    // don't include the object
    int scoreWithoutObject = fillKnapsack(objects, weight, currentScore);

    // include the object
    int newWeight = weight - originalObject.weight;
    int newScore = currentScore + originalObject.value;

    int scoreWithObject = fillKnapsack(objects, newWeight, newScore);

    objects.add(originalObject);

    return max(scoreWithObject, scoreWithoutObject);
}

// find the best solution including the objects
int fillKnapsack(Vector<objectT> &objects, int weight, int currentScore,
                 Vector<objectT> &currentSolutionObjects,
                 Vector<objectT> &bestSolutionObjects) {
    // base case #1: too much weight!
    if (weight < 0) {
        return 0;
    }

    if (objects.isEmpty()) {
        // calculate the score of the best solution
        int bestScoreSoFar = 0;
        for (objectT obj : bestSolutionObjects) {
            bestScoreSoFar += obj.value;
        }

        if (currentScore > bestScoreSoFar) {
            bestSolutionObjects = currentSolutionObjects;
        }
        return currentScore;
    }

    // remove an object for recursion, and save
    objectT originalObject = objects.remove(objects.size() - 1);

    // don't include the object
    int scoreWithoutObject =
        fillKnapsack(objects, weight, currentScore, currentSolutionObjects,
                     bestSolutionObjects);

    // include the object
    int newWeight = weight - originalObject.weight;
    int newScore = currentScore + originalObject.value;

    // put the object into the current bag
    currentSolutionObjects.add(originalObject);

    int scoreWithObject =
        fillKnapsack(objects, newWeight, newScore, currentSolutionObjects,
                     bestSolutionObjects);

    // remove the object from the current solution
    currentSolutionObjects.remove(currentSolutionObjects.size() - 1);

    objects.add(originalObject);

    return max(scoreWithObject, scoreWithoutObject);
}

int fillKnapsack(Vector<objectT> &objects, int targetWeight,
                 Vector<objectT> &solutionObjects) {
    Vector<objectT> currentSolutionObjects;
    return fillKnapsack(objects, targetWeight, 0, currentSolutionObjects,
                        solutionObjects);
}

// find all solutions, including the objects
void findAllKnapsackSolutions(Vector<objectT> &objects, int weight,
                              Vector<objectT> &currentSolutionObjects,
                              Vector<Vector<objectT>> &allSolutions) {
    // base case 1: we tried too much weight!
    if (weight < 0) {
        // not a valid solution
        return;
    }

    // base case 2: we are out of objects
    if (objects.isEmpty()) {
        // cout << "potential solution: " << currentSolutionObjects << endl;
        allSolutions.add(currentSolutionObjects);
        return;
    }

    // remove object for recursion, and save
    objectT originalObject = objects.remove(objects.size() - 1);

    // do not put the object in the bag and recurse
    findAllKnapsackSolutions(objects, weight, currentSolutionObjects,
                             allSolutions);

    int newWeight = weight - originalObject.weight;

    // put the object in the bag and recurse
    currentSolutionObjects.add(originalObject);
    findAllKnapsackSolutions(objects, newWeight, currentSolutionObjects,
                             allSolutions);
    currentSolutionObjects.remove(currentSolutionObjects.size() - 1);

    // replace object so calling function has same state as before call
    objects.add(originalObject);
}

void findAllKnapsackSolutions(Vector<objectT> &objects, int targetWeight,
                              Vector<Vector<objectT>> &allSolutions) {
    Vector<objectT> currentSolution;
    findAllKnapsackSolutions(objects, targetWeight, currentSolution,
                             allSolutions);
}

int main() {
    // solution: 44
    int values[] = {12, 10, 8, 11, 14, 7, 9};
    int weights[] = {4, 6, 5, 7, 3, 1, 6};
    int targetWeight = 18;

    // solution: 67
    //    int values[] = {5, 20, 3, 50, 5, 4, 15, 12, 6, 7};
    //    int weights[] = {6, 15, 11, 12, 6, 11, 13, 7, 17, 13};
    //    int targetWeight = 25;

    // solution: 7
    //    int values[] = {3, 4, 5, 6};
    //    int weights[] = {2, 3, 4, 5};
    //    int targetWeight = 5;

    int numItems = sizeof(values) / sizeof(int);

    Vector<objectT> testObjects;

    for (int i = 0; i < numItems; i++) {
        objectT object;
        object.value = values[i];
        object.weight = weights[i];
        testObjects.add(object);
    }

    cout << "Original objects: " << endl;
    for (objectT obj : testObjects) {
        cout << "value: " << obj.value << endl;
        cout << "weight: " << obj.weight << endl;
        cout << endl;
    }

    cout << "Target weight: " << targetWeight << endl << endl;

    cout << "Best solution has a value of: "
         << fillKnapsack(testObjects, targetWeight) << endl;
    cout << endl;

    cout << "Determining the objects in the best solution:" << endl;
    Vector<objectT> solution;
    int bestResult = fillKnapsack(testObjects, targetWeight, solution);

    cout << "Best solution has a value of: " << bestResult << endl;
    cout << "Objects in knapsack: " << endl;
    for (objectT obj : solution) {
        cout << "value: " << obj.value << endl;
        cout << "weight: " << obj.weight << endl;
        cout << endl;
    }

    // Find _all_ solutions
    cout << "Finding ALL solutions:" << endl << endl;
    Vector<Vector<objectT>> allSolutions;
    findAllKnapsackSolutions(testObjects, targetWeight, allSolutions);

    cout << "Original objects: " << endl;
    for (objectT obj : testObjects) {
        cout << "value: " << obj.value << endl;
        cout << "weight: " << obj.weight << endl;
        cout << endl;
    }

    cout << "Target weight: " << targetWeight << endl << endl;
    cout << "All solutions: " << endl << endl;

    int bestValue = 0;
    for (Vector<objectT> aSolution : allSolutions) {
        if (aSolution.isEmpty()) {
            cout << "{Empty set}" << endl;
        } else {
            for (objectT obj : aSolution) {
                cout << obj << endl;
            }
        }
        int score = 0;
        for (objectT obj : aSolution) {
            score += obj.value;
        }
        bestValue = max(bestValue, score);
        cout << "Value for solution: " << score << endl << endl;
    }
    cout << endl << "Best value: " << bestValue << endl;

    return 0;
}
