#include "ball.h"
#include "random.h"

Ball::Ball() {
    dx = randomReal(-DELTA_MAX, DELTA_MAX);
    dy = randomReal(-DELTA_MAX, DELTA_MAX);
}

void Ball::addToScreen(GWindow &window) {
    double x = window.getWidth() / 2;
    double y = window.getHeight() / 2;
    theBall.add(window, x, y, randomColor());
}

void Ball::takeStep(int screenWidth, int screenHeight) {
    if(theBall.getX() < DELTA_MAX || theBall.getX() > screenWidth - theBall.getSize()) {
        dx *= -1;
    }
    if(theBall.getY() < DELTA_MAX || theBall.getY() > screenHeight - theBall.getSize()) {
        dy *= -1;
    }
    theBall.move(dx, dy);
}

ostream& operator<<(ostream& out, Ball& ball){
    out << ball.dx << ", " << ball.dy;
    return out;
}
