#include <iostream>
#include "console.h"
#include "vector.h"
#include "dynamicInts.h"

using namespace std;

void squares(Vector<int> &vec, int numSquares) {
    for (int i=0; i < numSquares; i++) {
         vec.add(i * i);
    }
}

Vector<int> squares(int numSquares) {
    Vector<int> vec;
    for (int i=0; i < numSquares; i++) {
         vec.add(i * i);
    }
    return vec;
}

Vector<int> &veryBadNewsSquares(int numSquares) {
    Vector<int> vec;
    for (int i=0; i < numSquares; i++) {
         vec.add(i * i);
    }
    return vec; // this will break...
}

void printVec(const Vector<int>& vec) {
   for (int v : vec) {
       cout << v << endl;
   }
   cout << endl;
}

// we must pass along the value, as arrays
// don't have any functions, like length()
void printArray(const int arr[], int length) {
   for (int i = 0; i < length; i++) {
       cout << arr[i] << endl;
   }
   cout << endl;
}

int main() {
    Vector<int> someSquares;
    squares(someSquares, 10);
    printVec(someSquares);

    someSquares = squares(10);
    printVec(someSquares);

    // uncomment the two lines below to watch the world burn
//     someSquares = veryBadNewsSquares(10);
//     printVec(someSquares);

    cout << endl;
    int* anInteger = new int; // create one integer on the heap

    *anInteger = 5; // using a pointer...will cover next lecture!
    cout << *anInteger << endl << endl; // ditto

    delete anInteger; // does not actually delete anything
                      // "frees" the memory

    int firstTen[10]; // create a static array on the stack;
                      // only available for this function

    int* secondTen = new int[10]; // create 10 integers on the heap
                                  // Dynamically allocated and available for the rest of the program (if we wish)
    // fill memory with values
    for (int i=0; i < 10; i++) {
        firstTen[i] = i*2; // evens
        secondTen[i] = i*2 + 1; // odds
    }

    printArray(firstTen, 10);
    printArray(secondTen, 10);

    // nope -- we don't do this for static memory!
//     delete[] firstTen;

    // we need to give back access to secondTen
    delete[] secondTen;

    // don't try to use after deleting!
    // the following _might_ work after uncommenting,
    // but it is undefined behavior
//     printArray(secondTen, 10);


    int sum = 0;
    int* blockOfInts = new int[5];
    for (int i = 0; i < 5; i++) {
       blockOfInts[i] = 42;
    }

    for (int i = 0; i < 5; i++) {
       sum += blockOfInts[i];
    }

    delete[] blockOfInts; // give the memory back

    blockOfInts = new int[100]; // this is okay!

    for (int i = 0; i < 100; i++) {
       blockOfInts[i] = 142;
    }

    for (int i = 0; i < 100; i++) {
       sum += blockOfInts[i];
    }
    cout << "sum: " << sum << endl;
    delete[] blockOfInts; // not really deleting, giving back the memory!

    DynamicInts di;

    di.printValues();

    return 0;
}
