/*
 * File: gondor.cpp
 * -------------
 * This program simulates the lighting of the fires in The Lord of the Rings.
 */

#include <iostream>
#include <string>
#include "console.h"
#include "timer.h"
using namespace std;

struct Tower {
    string name;
    Tower* next;
};

Tower* createTower(string name, Tower* next) {
    Tower* temp = new Tower;
    temp->name = name;
    temp->next = next;
    return temp;
}

void signal(Tower* start) {
    if (start != nullptr) {
        cout << "Lighting " << start->name << endl;
        pause(500);
        signal(start->next);
    }
}


int main() {
    Tower* head = new Tower;
    head->name = "Rohan";
    head->next = nullptr;
    head = createTower("Halifirien", head);
    head = createTower("Calenhad", head);
    head = createTower("Min-Rimmon", head);
    head = createTower("Erelas", head);
    head = createTower("Nardol", head);
    head = createTower("Eilenach", head);
    head = createTower("Amon Din", head);


    pause(1000);
    signal(head);

    return 0;
}
