#include "SimpleTest.h" // IWYU pragma: keep (needed to quiet spurious warning)
#include "console.h"
#include<iostream>
#include<cctype>
#include "strlib.h"
#include "simpio.h"
#include "random.h"

using namespace std;

int sumDigitsSolution(string s);

int sumDigits(string s) {
    /* The sumDigits function returns the sum of all the digits in s.
      The funciton ignores negative numbers and only sums the individual
      digits. For example, `sumDigits("ab1c3d56--21x")` should return `18` (which is `1 + 3 + 5 + 6 + 2 + 1`).
      An empty string should return `0`.
      You are welcome to use functions from the `cctype` and `strlib.h` libraries.
   */

    // code here!

    return 0;
}

int main() {
    if (runSimpleTests(SELECTED_TESTS)) {
        return 0;
    }
    string s = getLine("Enter a string with numbers and characters and punctuation, etc.: ");
    int sum = sumDigits(s);
    cout << "The sum of the digits in the string: " << sum << endl;
    return 0;
}

PROVIDED_TEST("Test the string \"ab1c3d56--21x\".") {
    EXPECT_EQUAL(sumDigits("ab1c3d56--21x"), 18);
}

PROVIDED_TEST("Test empty string") {
    EXPECT_EQUAL(sumDigits(""), 0);
}

PROVIDED_TEST("Test a whole bunch of different strings") {
    for (int i = 0; i < 100; i++) {
        string testString;

        int numChars = randomInteger(1, 50);
        for (int chNum = 0; chNum < numChars; chNum++) {
            char ch = randomInteger(' ', '~');
            testString += ch;
        }
        cout << "Testing \"" << testString << "\"" << endl;
        EXPECT_EQUAL(sumDigits(testString), sumDigitsSolution(testString));
    }
}

// solution follows!
int sumDigitsSolution(string s) {
    int sum = 0;
    for (int ch : s) {
        if (isdigit(ch)) {
            int digit = charToInteger(ch);
            sum += digit;
        }
    }
    return sum;
}

