#include "StackInt.h"
#include "error.h"

// constructor
StackInt::StackInt(){
    _count = 0;
    _capacity = INIT_CAPACITY;
    _elements = new int[_capacity];
}

// destructor
StackInt::~StackInt(){
    delete [] _elements;
}

void StackInt::push(int value){
    if (_count == _capacity) {
        expand();
    }
    _elements[_count] = value;
    _count++;
}

int StackInt::pop(){
    if (_count == 0) {
        error("Cannot pop from an empty stack!");
    }
    _count--;
    int value = _elements[_count];
    return value;
}

int StackInt::peek() {
    if (_count == 0) {
        error("Cannot peek at an empty stack!");
    }
    return _elements[_count - 1];
}

bool StackInt::isEmpty(){
    return _count == 0;
}

int StackInt::size(){
    return _count;
}

std::ostream& operator<<(std::ostream& out, StackInt &stack){
    out << "top: [";
    for (int i = stack._count - 1; i >= 0; i--) {
        out << stack._elements[i];
        if (i > 0) {
            out << ", ";
        }
    }
    out << "]";
    return out;
}

void StackInt::expand(){
    // 1. ask for new space for a new array
    int* newElements = new int[_capacity * 2];

    // 2. copy the old values to the new array
    for (int i = 0; i < _capacity; i++) {
        newElements[i] = _elements[i];
    }

    // 3. delete the old array (give it back to the OS!)
    delete [] _elements;

    // 4. point the elements to the new array
    _elements = newElements;


    // 5. Update the capacity
    _capacity *= 2;
}

