#pragma once

#include <ostream>

const int INIT_CAPACITY = 8;

class StackInt {
public:
    // constructor
    StackInt();

    // destructor
    ~StackInt();

    void push(int value);

    int pop();

    int peek();

    bool isEmpty();

    int size();

    friend std::ostream& operator<<(std::ostream& out, StackInt &stack);

private:
    // the array of elements
    int* _elements;

    // how many elements are in the stack
    int _count;

    // how many elements the stack can hold
    int _capacity;

    // function to expand the elements to hold more
    void expand();
};
