#include "Trie.h"
#include <string>
#include <iostream>

using namespace std;

Trie::Trie() {
    _root = new TrieNode();
}

Trie::~Trie() {
    deleteTrie(_root);
}

void Trie::deleteTrie(TrieNode* node) {
    if (node == nullptr) return;

    for (char key : node->children) {
        deleteTrie(node->children[key]);
    }
    delete node;
}

void Trie::insert(const string &word) {
    cout << "\tinsert(" << word << ")" << endl;
    TrieNode* node = _root;
    for (char c : word) {
        cout << "\t\tchecking " << c << endl;
        if (!node->children.containsKey(c)) {
            cout << "\t\t\tnot found, creating node" << endl;
            node->children[c] = new TrieNode();
        } else {
            cout << "\t\t\tfound" << endl;
        }
        node = node->children[c];
    }
    cout << "\t\tsetting the end of the word to be true at this node" << endl;
    node->isEndOfWord = true;
}

bool Trie::search(const string &word) const {
    TrieNode* node = _root;
    for (char c : word) {
        cout << "\t\tchecking " << c << endl;
        if (!node->children.containsKey(c)) {
            cout << "\t\t\tnot found, returning false" << endl;
            return false;
        }
        node = node->children[c];
    }
    cout << "\t\tEnd of word is " << (node->isEndOfWord ? "true" : "false") << endl;
    return node->isEndOfWord;
}

bool Trie::startsWith(const string &prefix) const {
    TrieNode* node = _root;
    for (char c : prefix) {
        cout << "\t\tchecking " << c << endl;
        if (!node->children.containsKey(c)) {
            cout << "\t\t\tnot found, returning false" << endl;
            return false;
        }
        node = node->children[c];
    }
    return true;
}
