#include "Trie.h"
#include "console.h"
#include "vector.h"
using namespace std;

int main() {
    Trie trie;

    // Insert words into the trie
    Vector<string> inserts = {"apple", "app", "bat", "ball", "cats"};
    for (string s : inserts) {
        cout << "Inserting " << s << " into the trie" << endl;
        trie.insert(s);
        cout << endl;
    }
    cout << endl;

    // Search for complete words
    cout << "Searching for 'apple': " << endl << (trie.search("apple") ? "Found" : "Not found") << endl;
    cout << "Searching for 'app': " << endl << (trie.search("app") ? "Found" : "Not found") << endl;
    cout << "Searching for 'bat': " << endl << (trie.search("bat") ? "Found" : "Not found") << endl;
    cout << "Searching for 'ball': " << endl << (trie.search("ball") ? "Found" : "Not found") << endl;
    cout << "Searching for 'batman': " << endl << (trie.search("batman") ? "Found" : "Not found") << endl;
    cout << "Searching for 'cat': " << endl << (trie.search("cat") ? "Found" : "Not found") << endl;

    cout << endl;

    // Check for prefixes
    cout << "Checking prefix 'app': " << (trie.startsWith("app") ? "Exists" : "Does not exist") << endl;
    cout << "Checking prefix 'bat': " << (trie.startsWith("bat") ? "Exists" : "Does not exist") << endl;
    cout << "Checking prefix 'bal': " << (trie.startsWith("bal") ? "Exists" : "Does not exist") << endl;
    cout << "Checking prefix 'cat': " << (trie.startsWith("cat") ? "Exists" : "Does not exist") << endl;

    return 0;
}
