#include<iostream>
#include<fstream>
#include "vector.h"
#include "strlib.h"
#include "set.h"
#include "map.h"
#include "stack.h"
#include "queue.h"
#include "grid.h"
#include "console.h"
#include "random.h"
#include "filelib.h"
#include "SimpleTest.h" // IWYU pragma: keep (needed to quiet spurious warning)

using namespace std;

void readMazeFile(string filename, Grid<bool>& maze);

void p3();
void p6();

int main() {
    struct functionDetails {
        string funcName;
        void(*func)();
    };

    Vector<functionDetails> functions = {{"p3", p3},
                                         {"p6", p6}};
    for (functionDetails fd : functions) {
        cout << "**************************" << endl;
        cout << "Testing " << fd.funcName << endl;
        fd.func();
        cout << "Done testing " << fd.funcName << endl;
        cout << "**************************" << endl << endl;
    }
    return 0;
}

string firstNonRepeatingStream(const string s) {
    Map<char,int> freq;
    Queue<char> q;
    string result;

    // your code here

    return result;
}
















string firstNonRepeatingStreamSolution(const string s) {
    Map<char,int> freq;
    Queue<char> q;
    string result;

    for (char c : s) {
        freq[c]++;    // update count
        q.enqueue(c); // keep arrival order

        // Discard any queue front that is no longer unique
        while (!q.isEmpty() && freq[q.peek()] > 1) {
            q.dequeue();
        }

        if (q.isEmpty()) {
            result += '_';
        } else {
            result += q.peek();
        }
    }
    return result;
}

void p3() {
    Vector<string> inputStrings = {"aabcbcdbe", "abcdeaf", "", "aabbccdd", "abbbac"};
    for (string s : inputStrings) {
        string outputString = firstNonRepeatingStream(s);
        cout << "Input string: " << s <<  ", Output string: " << outputString << endl;
    }
}

Set<GridLocation> generateValidMoves(Grid<bool>& g, GridLocation cur) {
    // put your code from A2 here
    Set<GridLocation> allDirections {
        {cur.row - 1, cur.col}, // north
        {cur.row + 1, cur.col}, // south
        {cur.row, cur.col + 1}, // east
        {cur.row, cur.col - 1}  // west
    };
    Set<GridLocation> valid;

    for (GridLocation dir : allDirections) {
        if (g.inBounds(dir) && g[dir])
            valid.add(dir);
    }
    return valid;
}

void validatePath(Grid<bool>& maze, Vector<GridLocation>& path) {
    // put your code from A2 here
    if (path.isEmpty()) error("Path is empty");
    GridLocation mazeEntry = {0, 0};
    GridLocation mazeExit = {maze.numRows() - 1,  maze.numCols() - 1};
    if (path[0] != mazeEntry) error("Path does not begin at maze entry");
    if (path[path.size()-1] != mazeExit) error("Path does not end at maze exit");

    Set<GridLocation> visited = {path[0]};
    // starting from 0 can create some fencepost and OOB bugs so beware of those.
    // Some students may split these checks into two. There will check for all other errors
    // in one code block, then check for teleportation in another. That's also perfectly fine!
    for (int i = 1; i < path.size(); i++) {
        GridLocation current = path[i];
        if (!maze.inBounds(current)) error("Path location not in bounds");
        if (!maze[current]) error("Path location moves through a wall");
        // if they start from 0, then they should check that `i + 1` is in range.
        if (!generateValidMoves(maze, path[i-1]).contains(current)) error("Path teleports, not a valid move");
        if (visited.contains(current)) error("Path location revisits previous location, has loop");
        visited.add(current);
    }
}

void solveMazeDFSRecursiveHelper(Grid<bool>& maze, Vector<GridLocation> &path, Set<GridLocation> &visited) {
    GridLocation pathEnd = path[path.size() - 1];
    GridLocation mazeExit = {maze.numRows() - 1, maze.numCols() - 1};

    // your code here
}

















void solveMazeDFSRecursiveHelperSoln(Grid<bool>& maze, Vector<GridLocation> &path, Set<GridLocation> &visited) {
    GridLocation pathEnd = path[path.size() - 1];
    GridLocation mazeExit = {maze.numRows() - 1, maze.numCols() - 1};

    // base case
    if (pathEnd == mazeExit) {
        return;
    }

    for (GridLocation possibleNext : generateValidMoves(maze, pathEnd)) {
        // chose the next path
        if (!visited.contains(possibleNext)) {
            path.add(possibleNext);
            visited.add(possibleNext);
            solveMazeDFSRecursiveHelperSoln(maze, path, visited);
            if (path[path.size() - 1] == mazeExit) {
                break;
            }
            // undo
            path.remove(path.size() - 1);
        }
    }
}

Vector<GridLocation> solveMazeDFSRecursive(Grid<bool>& maze) {
    GridLocation start = {0, 0};
    Set<GridLocation> visited;
    Vector<GridLocation> solution;
    solution.add(start);
    visited.add(start);
    solveMazeDFSRecursiveHelper(maze, solution, visited);
    return solution;
}

void p6() {
    Vector<string> mazes = {
        "res/2x2.maze",
        "res/5x7.maze",
        "res/13x39.maze",
        "res/17x37.maze",
        "res/19x35.maze",
        "res/21x23.maze",
        "res/21x25.maze",
        "res/21x35.maze",
        "res/25x15.maze",
        "res/25x33.maze",
        "res/33x41.maze",
    };
    Grid<bool> maze;
    for (string mazeFile : mazes) {
        cout << "Solving " << mazeFile << endl;
        readMazeFile(mazeFile, maze);
        Vector<GridLocation> soln = solveMazeDFSRecursive(maze);

        validatePath(maze, soln);
        cout << "Okay!" << endl;
    }
}

void readMazeFile(string filename, Grid<bool>& maze) {
    /* The following code reads data from the file into a Vector
     * of strings representing the lines of the file.
     */
    ifstream in;

    if (!openFile(in, filename))
        error("Cannot open file named " + filename);

    Vector<string> lines = stringSplit(readEntire(in), '\n');

    /* Now that the file data has been read into the Vector, populate
     * the maze grid.
     */
    int numRows = lines.size();        // rows is count of lines
    int numCols = lines[0].length();   // cols is length of line
    maze.resize(numRows, numCols);     // resize grid dimensions

    for (int r = 0; r < numRows; r++) {
        if (lines[r].length() != numCols) {
            error("Maze row has inconsistent number of columns");
        }
        for (int c = 0; c < numCols; c++) {
            char ch = lines[r][c];
            if (ch == '@') {        // wall
                maze[r][c] = false;
            } else if (ch == '-') { // corridor
                maze[r][c] = true;
            } else {
                error("Maze location has invalid character: '" + charToString(ch) + "'");
            }
        }
    }
}
