
/*******************************************************************
kinggeorge.cpp
Cynthia Bailey
07-01-2026
A program to generate lyrics like those from Hamilton. Lyrics, for
reference:

"You'll Be Back"
(from "Hamilton: An American Musical" soundtrack)

...[Verse 1]...
And when push comes to shove
I will send a fully armed battalion to remind you of my love!

Da da da dat da dat da da da da ya da
Da da dat dat da ya da!
Da da da dat da dat da da da da ya da
Da da dat dat da…

...[Verse 2]...

Da da da dat da dat da da da da ya da
Da da dat dat da ya da!
Da da da dat da dat da da da da ya da
Da da dat—
Everybody!

[Full Ensemble:]
Da da da dat da dat da da da da ya da
Da da dat dat da ya da!
Da da da dat da dat da da da da ya da da da da
Dat dat da ya da!
*******************************************************************/
#include <iostream>
#include <string>
#include "console.h"
#include "simpio.h"
using namespace std;

string generateLyrics(int daAmount);

const int DAT_FREQ = 3;
const int YA_FREQ  = 8;

int main()
{
    while (true) {
        int daAmount = getInteger("How much Da? (0 to exit) ");
        if (daAmount < 1) {
            break;
        }
        cout << generateLyrics(daAmount) << endl;
    }
    cout << "All done, exiting." << endl;
    return 0;
}

/* Function: generateLyrics()
 *
 * Generates lyrics in the style of Hamilton's King Geroge.
 * Takes an integer length of lyrics to generate (number of
 * syllables). Returns a string containing the lyrics.
 *
 * - Repeat "Da" a bunch of times (daAmount times)
 * - Every 3rd "Da" should actually be "Dat"
 * - Every 8th "Da" should be preceeded by a "Ya"
 *
 * Parameter daAmount should be non-negative.
 */
string generateLyrics(int daAmount)
{
    string lyrics = "";
    // start with 1 so we get "Da" first, not "Dat"
    for (int i = 1; i <= daAmount; i++) {
        if (i % DAT_FREQ == 0) {
            lyrics += "Dat ";
        } else if (i % YA_FREQ == 0) {
            lyrics += "Ya Da ";
        } else {
            lyrics += "Da ";
        }
    }
    return lyrics;
}


