
/*******************************************************************
kinggeorge.cpp
Cynthia Bailey
07-01-2026
A program to generate lyrics like those from Hamilton. Lyrics, for
reference:

"You'll Be Back"
(from "Hamilton: An American Musical" soundtrack)

...[Verse 1]...
And when push comes to shove
I will send a fully armed battalion to remind you of my love!

Da da da dat da dat da da da da ya da
Da da dat dat da ya da!
Da da da dat da dat da da da da ya da
Da da dat dat da…

...[Verse 2]...

Da da da dat da dat da da da da ya da
Da da dat dat da ya da!
Da da da dat da dat da da da da ya da
Da da dat—
Everybody!

[Full Ensemble:]
Da da da dat da dat da da da da ya da
Da da dat dat da ya da!
Da da da dat da dat da da da da ya da da da da
Dat dat da ya da!
*******************************************************************/
#include <iostream>
#include <string>
#include "console.h"
#include "simpio.h"
#include "SimpleTest.h"
using namespace std;

// Function prototypes
string generateLyrics(int daAmount);

// Constants
const int YA_FREQ  = 8;
const int DAT_FREQ = 3;

int main()
{
/*  OLD MAIN: repeat tests of generateLyrics manually
     while (true) {
        int daAmount = getInteger("How much Da? (0 to exit) ");
        if (daAmount < 1) {
            break;
        }
        string lyrics = generateLyrics(daAmount);
        cout << lyrics << endl;
    }
*/

    // NEW MAIN: use CS106B testing framework
    if (runSimpleTests(SELECTED_TESTS)) {
        return 0;
    }

    cout << "All done, exiting." << endl;
    return 0;
}


/* Function: generateLyrics()
 *
 * Generates lyrics in the style of Hamilton's King Geroge.
 * Takes an integer length of lyrics to generate (number of
 * syllables). Returns a string containing the lyrics.
 *
 * - Repeat "Da" a bunch of times (daAmount times)
 * - Every 3rd "Da" should actually be "Dat"
 * - Every 8th "Da" should be preceeded by a "Ya"
 *
 * Parameter daAmount should be non-negative.
 */
string generateLyrics(int daAmount)
{
    string lyrics = "";

    for (int i = 1; i <= daAmount; i++) {
        if (i % YA_FREQ == 0) {
            lyrics += "Ya Da ";
        } else if (i % DAT_FREQ == 0) {
            lyrics += "Dat ";
        } else {
            lyrics += "Da ";
        }
    }

    return lyrics;
}


/* * * * * * Test Cases * * * * * */

PROVIDED_TEST("Basic function: 1 syllable")
{
    EXPECT_EQUAL(generateLyrics(1), "Da ");
}

PROVIDED_TEST("Basic function: 2 syllables")
{
    EXPECT_EQUAL(generateLyrics(2), "Da Da ");
}

STUDENT_TEST("<description1>")
{
}

STUDENT_TEST("<description2>")
{
}

STUDENT_TEST("<description3>")
{
}


