/*
 * CS106B - Cynthia Bailey - Winter 2026
 *
 * Demonstration of performance difference in building up a Vector,
 * depending on location of insertion.
 */
#include <iostream>
#include "vector.h"
#include "console.h"
#include "SimpleTest.h"
using namespace std;

void runInsert(int size);
void runAdd(int size);
void runInsertInMiddle(int size);
void runInsertAtEnd(int size);

const int VECTOR_TEST_SIZE = 500000;

int main()
{
    if (runSimpleTests(SELECTED_TESTS)) {
        return 0;
    }

    cout << "All done, exiting" << endl;
    return 0;
}


void runInsert(int size)
{
    Vector<int> v;
    for (int i = 0; i < size; i++) {
        v.insert(0, i);
    }
}

void runAdd(int size)
{
    Vector<int> v;
    for (int i = 0; i < size; i++) {
        v.add(i);
    }
}

void runInsertInMiddle(int size)
{
    Vector<int> v;
    for (int i = 0; i < size; i++) {
        v.insert(v.size() / 2, i);
    }
}

void runInsertAtEnd(int size)
{
    Vector<int> v;
    for (int i = 0; i < size; i++) {
        v.insert(v.size(), i);
    }
}

/* * * * * * Test Cases * * * * * */

PROVIDED_TEST("Timing comparison of add() at the end and insert() at the beginning")
{
    TIME_OPERATION(VECTOR_TEST_SIZE, runInsert(VECTOR_TEST_SIZE));
    TIME_OPERATION(VECTOR_TEST_SIZE, runAdd(VECTOR_TEST_SIZE));
}

STUDENT_TEST("Showing that insert() isn't the problem per se, it's the location")
{
    TIME_OPERATION(VECTOR_TEST_SIZE, runInsertInMiddle(VECTOR_TEST_SIZE));
    TIME_OPERATION(VECTOR_TEST_SIZE, runInsertAtEnd(VECTOR_TEST_SIZE));
}


