/*
 * fibonacci.cpp
 *
 * @author Cynthia Bailey
 * @version Winter 2026
*
 * Demonstrates a naive recursive implementation of Fibonacci, and then
 * a more efficient verison that uses memoization.
 *
 */
#include <iostream>
#include "console.h"
#include "random.h"
#include "vector.h"
#include "SimpleTest.h"
using namespace std;

/* Function Prototypes */
int fibonacci(int n);
int fasterFibonacci(int n);
int fasterFibonacci(int n, Vector<int>& memos);

/* Constants */

static const int NOT_YET_SAVED = -1;

/*
 * Generate a vector with random data, then sort it, then allow user to
 * search for values using our recursive binary search impelementation.
 */
int main()
{
    if (runSimpleTests(SELECTED_TESTS)) {
        return 0;
    }
    cout << "All done, exiting" << endl;
    return 0;
}

/*
 * Returns the n-th number in the Fibonnaci sequence, given an input n.
 *
 * PRE: n is non-negative.
 *
 * Remark: uses a naive recursive implementation with exponential runtime cost.
 */
int fibonacci(int n)
{
    if (n == 0) {
        return 0;
    } else if (n == 1) {
        return 1;
    } else {
        return fibonacci(n - 1) + fibonacci(n - 2);
    }
}


/*
 * Returns the n-th number in the Fibonnaci sequence, given an input n.
 *
 * PRE: n is non-negative.
 *
 * Remark: uses memoization to achieve O(N) runtime cost.
 */
int fasterFibonacci(int n)
{
    // This will hold our results as memos[n] = Fib(n), starting with our base cases.
    // We must initialize the Vector to have indices 0...n, so size must be n+1, and
    // must at minimum have size 2 so that we don't crash when initializing our two
    // base cases.
    Vector<int> memos(max(n + 1, 2), NOT_YET_SAVED);
    memos[0] = 0;
    memos[1] = 1;
    return fasterFibonacci(n, memos);
}


/*
 * Recursive helper function for fasterFibonacci.
 */
int fasterFibonacci(int n, Vector<int>& memos)
{
    // if we already know the answer, just return it
    if (memos[n] != NOT_YET_SAVED) {
        return memos[n];
    } else {
        // calculate new answer and save it for later
        int result = fasterFibonacci(n - 1, memos) + fasterFibonacci(n - 2, memos);
        memos[n] = result;
        return result;
    }
}




/* * * * * * Test Cases * * * * * */


PROVIDED_TEST("Timing fasterFibonacci() with memoization")
{
    TIME_OPERATION(20, fasterFibonacci(20));
    TIME_OPERATION(40, fasterFibonacci(40));
    TIME_OPERATION(60, fasterFibonacci(60));
    TIME_OPERATION(80, fasterFibonacci(80));
    TIME_OPERATION(100, fasterFibonacci(100));
    TIME_OPERATION(1000, fasterFibonacci(1000));
    TIME_OPERATION(10000, fasterFibonacci(10000));
}

// Gets close to being too much for my laptop after 40
PROVIDED_TEST("Timing fibonacci() naive recursive")
{
    TIME_OPERATION(20, fibonacci(20));
    TIME_OPERATION(40, fibonacci(40));
    TIME_OPERATION(41, fibonacci(41));
    TIME_OPERATION(42, fibonacci(42));
    TIME_OPERATION(43, fibonacci(43));
    TIME_OPERATION(44, fibonacci(44));
    TIME_OPERATION(45, fibonacci(45));
}

/***************************************************************/

STUDENT_TEST("fibonacci() basic correctness")
{
    EXPECT_EQUAL(fibonacci(0), 0);
    EXPECT_EQUAL(fibonacci(1), 1);
    EXPECT_EQUAL(fibonacci(2), 1);
    EXPECT_EQUAL(fibonacci(3), 2);
    EXPECT_EQUAL(fibonacci(4), 3);
    EXPECT_EQUAL(fibonacci(5), 5);
    EXPECT_EQUAL(fibonacci(6), 8);
    EXPECT_EQUAL(fibonacci(7), 13);
    EXPECT_EQUAL(fibonacci(8), 21);
}

STUDENT_TEST("fasterFibonacci() basic correctness")
{
    EXPECT_EQUAL(fasterFibonacci(0), 0);
    EXPECT_EQUAL(fasterFibonacci(1), 1);
    EXPECT_EQUAL(fasterFibonacci(2), 1);
    EXPECT_EQUAL(fasterFibonacci(3), 2);
    EXPECT_EQUAL(fasterFibonacci(4), 3);
    EXPECT_EQUAL(fasterFibonacci(5), 5);
    EXPECT_EQUAL(fasterFibonacci(6), 8);
    EXPECT_EQUAL(fasterFibonacci(7), 13);
    EXPECT_EQUAL(fasterFibonacci(8), 21);
}

