/*
 * Cynthia Bailey
 * CS106B - Winter 2026 version
 *
 * hospitalq-client.cpp
 *
 * This program is a client that tests the HospitalQueue class.
 */

#include <iostream>
#include "console.h"
#include "hospitalq.h"
#include "SimpleTest.h"
#include "strlib.h"
using namespace std;



int main()
{
    if (runSimpleTests(SELECTED_TESTS)) {
        return 0;
    }
    cout << "All done, exiting" << endl;
    return 0;
}



/* * * * * * Test Cases * * * * * */

PROVIDED_TEST("Basic small case for: isEmpty, enqueue, asString, front") {
    HospitalQueue pq;
    EXPECT(pq.isEmpty());
    int testPriorities[] = {5, 8, 9, 7, 1, 10, 3, 4, 6, 2};
    for (int i = 0; i < 10; i++) {
        Patient test;
        test.name = "FirstName" + integerToString(testPriorities[i]);
        test.priority = testPriorities[i];
        pq.enqueue(test);
        // periodically check in on correctness of front()
        if (i == 3) {
            EXPECT_EQUAL(pq.front().name, "FirstName5");
            EXPECT_EQUAL(pq.front().priority, 5);
        } else if (i == 7) {
            EXPECT_EQUAL(pq.front().name, "FirstName1");
            EXPECT_EQUAL(pq.front().priority, 1);
        }
    }
    EXPECT_EQUAL(pq.asString(), "{ 1 2 3 5 4 10 9 8 6 7 }");
    EXPECT_EQUAL(pq.front().name, "FirstName1");
    EXPECT_EQUAL(pq.front().priority, 1);
}


STUDENT_TEST("TODO: larger size that forces re-size of array structure") {
}

STUDENT_TEST("TODO: dequeue") {
}
