/*
 * Cynthia Bailey
 * CS106B - Winter 2026 version
 *
 * hospitalq.h
 *
 * This header declares the HospitalQueue class and its
 * members. The HospitalQueue implements a Priority Queue
 * ADT, exposing an interface to access enqueued items of
 * type Patient in priority order.
 *
 * * The priority queue is implemented as a binary heap.
 * * The Patient, a struct, is also defined here.
 * * The smaller the priority number, the higher the
 *   priority (min-heap).
 *
 */

#ifndef _hospitalq_h
#define _hospitalq_h

#include <iostream>
using namespace std;

typedef struct Patient {
    string  name;
    int     priority;
} Patient;


class HospitalQueue {
public:
    /* Constructs a new empty priority queue. */
    HospitalQueue();

    /* Destructor; called when priority queue is thrown out. */
    ~HospitalQueue();

    /* Returns the highest-priority element without removing it.
     * Throws an exception if priority queue is empty. */
    Patient front();

    /* Adds the given patient to the priority queue. */
    void enqueue(Patient newPatient);

    /* Removes and returns the highest-priority patient.
     * Throws an exception if priority queue is empty. */
    Patient dequeue();

    /* Returns true if the priority queue does not contain any patients. */
    bool isEmpty();

    /* Writes the contents to a string (for testing). */
    string asString();

private:
    Patient* _elements;     // array of elements
    int  _size;             // number of elements
    int  _capacity;         // array length

    /* Makes the pq's internal array twice as large. */
    void enlargeArray();

    /* Given the index of a child, returns the index of the parent
     * (undefined if no parent exists; i.e., if given child is root). */
    int parentIndex(int child);

    /* Given the index of a child, returns the priority of the parent
     * (undefined if no parent exists; i.e., if given child is root). */
    int parentPriority(int child);

    /* Swaps the patients in the given indices. */
    void swap(int index1, int index2);

    /* Given the index of a parent, returns the index of where the left
     * child would go (does not check if child exists). */
    int leftChildIndex(int parent);

    /* Given the index of a parent, returns the index of where the right
     * child would go (does not check if child exists). */
    int rightChildIndex(int parent);
};

#endif
