#include "testing/SimpleTest.h"
#include "search.h"
using namespace std;

// Returns the index of an element in v matching target or -1 if not found
int linearSearch(const Vector<int>& v, int target)
{
    for (int i = 0; i < v.size(); i++) {
        if (v[i] == target) {
            return i;
        }
    }
    return -1;
}


/* * * * * * Test Cases * * * * * */

// The fillInOrder() helper function adds sequence of random-ish values in sorted order
// It is used to create test case inputs

static void fillInOrder(Vector<int>& v, int size, bool allowDuplicates)
{
    v.clear();
    v.add(randomInteger(0, 1000));
    for (int i = 1; i < size; i++) {
        // what does the line below do?
        v.add(v[i-1] + randomInteger( (allowDuplicates ? 0 : 1), 10));
    }
}

PROVIDED_TEST("Linear search: finds target, simple case") {
    Vector<int> v = {4, 35};
    EXPECT_EQUAL(linearSearch(v, v[0]), 0);
    EXPECT_EQUAL(linearSearch(v, v[1]), 1);
}

PROVIDED_TEST("Linear search: returns -1 when target not found") {
    Vector<int> v = {4, 35};
    EXPECT_EQUAL(linearSearch(v, 179), -1);
    EXPECT_EQUAL(linearSearch(v, 22), -1);
}

PROVIDED_TEST("Linear search: returns -1 when search empty vector") {
    Vector<int> empty = {};
    EXPECT_EQUAL(linearSearch(empty, 0), -1);
}

PROVIDED_TEST("Linear search: finds target at index first/middle/last") {
    Vector<int> v;
    int size = 25;
    fillInOrder(v, size, false /* disallow duplicates */);

    // spot check find elements at first/middle/last
    EXPECT_EQUAL(linearSearch(v, v[0]), 0);
    EXPECT_EQUAL(linearSearch(v, v[size/2]), size/2);
    EXPECT_EQUAL(linearSearch(v, v[size-1]), size-1);
}

PROVIDED_TEST("Linear search: large random stress test (BUGGY TEST)") {
    Vector<int> v;
    int size = 200;
    fillInOrder(v, size, true /* allow duplicates */);

    // confirm every single element is found
    for (int index = 0; index < v.size(); index++) {
        int target = v[index];
        int found = linearSearch(v, target);
        // in what situation does this test not work correctly?
        EXPECT_EQUAL(found, index);
    }
}

PROVIDED_TEST("Linear search: large random stress test") {
    Vector<int> v;
    int size = 200;
    fillInOrder(v, size, true /* allow duplicates */);

    for (int index = 0; index < v.size(); index++) {
        int target = v[index];
        int found = linearSearch(v, target);
        // how does this test avoid the problem that test above exhibited?
        EXPECT_EQUAL(v[found], target);
    }
}

PROVIDED_TEST("Linear search: time trials, expected to be linear O(n)") {
    Vector<int> v;
    int size = 1000000;

    // handy use of loop to do multiple time trials
    for (int i = 0; i < 4; i++) {
        fillInOrder(v, size, true /* allow duplicates */);
        int nonexistent = v[0] - 1; // this value guaranteed to not be in v, do you see why?
        TIME_OPERATION(size, linearSearch(v, nonexistent));
        size *= 2;
    }
}
